package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PolicyV1beta1PodSecurityPolicyListBuilder extends PolicyV1beta1PodSecurityPolicyListFluentImpl<PolicyV1beta1PodSecurityPolicyListBuilder> implements VisitableBuilder<PolicyV1beta1PodSecurityPolicyList,PolicyV1beta1PodSecurityPolicyListBuilder>{

    PolicyV1beta1PodSecurityPolicyListFluent<?> fluent;
    Boolean validationEnabled;

    public PolicyV1beta1PodSecurityPolicyListBuilder(){
            this(true);
    }
    public PolicyV1beta1PodSecurityPolicyListBuilder(Boolean validationEnabled){
            this(new PolicyV1beta1PodSecurityPolicyList(), validationEnabled);
    }
    public PolicyV1beta1PodSecurityPolicyListBuilder(PolicyV1beta1PodSecurityPolicyListFluent<?> fluent){
            this(fluent, true);
    }
    public PolicyV1beta1PodSecurityPolicyListBuilder(PolicyV1beta1PodSecurityPolicyListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new PolicyV1beta1PodSecurityPolicyList(), validationEnabled);
    }
    public PolicyV1beta1PodSecurityPolicyListBuilder(PolicyV1beta1PodSecurityPolicyListFluent<?> fluent,PolicyV1beta1PodSecurityPolicyList instance){
            this(fluent, instance, true);
    }
    public PolicyV1beta1PodSecurityPolicyListBuilder(PolicyV1beta1PodSecurityPolicyListFluent<?> fluent,PolicyV1beta1PodSecurityPolicyList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withItems(instance.getItems());

            fluent.withKind(instance.getKind());

            fluent.withMetadata(instance.getMetadata());

            this.validationEnabled = validationEnabled; 
    }
    public PolicyV1beta1PodSecurityPolicyListBuilder(PolicyV1beta1PodSecurityPolicyList instance){
            this(instance,true);
    }
    public PolicyV1beta1PodSecurityPolicyListBuilder(PolicyV1beta1PodSecurityPolicyList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withItems(instance.getItems());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.validationEnabled = validationEnabled; 
    }

    public PolicyV1beta1PodSecurityPolicyList build(){
            PolicyV1beta1PodSecurityPolicyList buildable = new PolicyV1beta1PodSecurityPolicyList();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setItems(fluent.getItems());
            buildable.setKind(fluent.getKind());
            buildable.setMetadata(fluent.getMetadata());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PolicyV1beta1PodSecurityPolicyListBuilder that = (PolicyV1beta1PodSecurityPolicyListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
