package io.kubernetes.client.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class V1CephFSPersistentVolumeSourceFluentImpl<A extends V1CephFSPersistentVolumeSourceFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1CephFSPersistentVolumeSourceFluent<A>{

    private List<String> monitors;
    private String path;
    private Boolean readOnly;
    private String secretFile;
    private V1SecretReferenceBuilder secretRef;
    private String user;

    public V1CephFSPersistentVolumeSourceFluentImpl(){
    }
    public V1CephFSPersistentVolumeSourceFluentImpl(V1CephFSPersistentVolumeSource instance){
            this.withMonitors(instance.getMonitors());

            this.withPath(instance.getPath());

            this.withReadOnly(instance.isReadOnly());

            this.withSecretFile(instance.getSecretFile());

            this.withSecretRef(instance.getSecretRef());

            this.withUser(instance.getUser());

    }

    public A addToMonitors(int index,String item){
            if (this.monitors == null) {this.monitors = new ArrayList<String>();}
            this.monitors.add(index, item);
            return (A)this;
    }

    public A setToMonitors(int index,String item){
            if (this.monitors == null) {this.monitors = new ArrayList<String>();}
            this.monitors.set(index, item); return (A)this;
    }

    public A addToMonitors(String... items){
            if (this.monitors == null) {this.monitors = new ArrayList<String>();}
            for (String item : items) {this.monitors.add(item);} return (A)this;
    }

    public A addAllToMonitors(Collection<String> items){
            if (this.monitors == null) {this.monitors = new ArrayList<String>();}
            for (String item : items) {this.monitors.add(item);} return (A)this;
    }

    public A removeFromMonitors(String... items){
            for (String item : items) {if (this.monitors!= null){ this.monitors.remove(item);}} return (A)this;
    }

    public A removeAllFromMonitors(Collection<String> items){
            for (String item : items) {if (this.monitors!= null){ this.monitors.remove(item);}} return (A)this;
    }

    public List<String> getMonitors(){
            return this.monitors;
    }

    public String getMonitor(int index){
            return this.monitors.get(index);
    }

    public String getFirstMonitor(){
            return this.monitors.get(0);
    }

    public String getLastMonitor(){
            return this.monitors.get(monitors.size() - 1);
    }

    public String getMatchingMonitor(io.kubernetes.client.fluent.Predicate<String> predicate){
            for (String item: monitors) { if(predicate.apply(item)){return item;} } return null;
    }

    public Boolean hasMatchingMonitor(io.kubernetes.client.fluent.Predicate<String> predicate){
            for (String item: monitors) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withMonitors(List<String> monitors){
            if (this.monitors != null) { _visitables.get("monitors").removeAll(this.monitors);}
            if (monitors != null) {this.monitors = new ArrayList<String>(); for (String item : monitors){this.addToMonitors(item);}} else { this.monitors = null;} return (A) this;
    }

    public A withMonitors(String... monitors){
            if (this.monitors != null) {this.monitors.clear();}
            if (monitors != null) {for (String item :monitors){ this.addToMonitors(item);}} return (A) this;
    }

    public Boolean hasMonitors(){
            return monitors != null && !monitors.isEmpty();
    }

    public A addNewMonitor(String arg1){
            return (A)addToMonitors(new String(arg1));
    }

    public A addNewMonitor(StringBuilder arg1){
            return (A)addToMonitors(new String(arg1));
    }

    public A addNewMonitor(StringBuffer arg1){
            return (A)addToMonitors(new String(arg1));
    }

    public String getPath(){
            return this.path;
    }

    public A withPath(String path){
            this.path=path; return (A) this;
    }

    public Boolean hasPath(){
            return this.path != null;
    }

    public A withNewPath(String arg1){
            return (A)withPath(new String(arg1));
    }

    public A withNewPath(StringBuilder arg1){
            return (A)withPath(new String(arg1));
    }

    public A withNewPath(StringBuffer arg1){
            return (A)withPath(new String(arg1));
    }

    public Boolean isReadOnly(){
            return this.readOnly;
    }

    public A withReadOnly(Boolean readOnly){
            this.readOnly=readOnly; return (A) this;
    }

    public Boolean hasReadOnly(){
            return this.readOnly != null;
    }

    public A withNewReadOnly(String arg1){
            return (A)withReadOnly(new Boolean(arg1));
    }

    public A withNewReadOnly(boolean arg1){
            return (A)withReadOnly(new Boolean(arg1));
    }

    public String getSecretFile(){
            return this.secretFile;
    }

    public A withSecretFile(String secretFile){
            this.secretFile=secretFile; return (A) this;
    }

    public Boolean hasSecretFile(){
            return this.secretFile != null;
    }

    public A withNewSecretFile(String arg1){
            return (A)withSecretFile(new String(arg1));
    }

    public A withNewSecretFile(StringBuilder arg1){
            return (A)withSecretFile(new String(arg1));
    }

    public A withNewSecretFile(StringBuffer arg1){
            return (A)withSecretFile(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildSecretRef instead.
 * @return The buildable object.
 */
@Deprecated public V1SecretReference getSecretRef(){
            return this.secretRef!=null?this.secretRef.build():null;
    }

    public V1SecretReference buildSecretRef(){
            return this.secretRef!=null?this.secretRef.build():null;
    }

    public A withSecretRef(V1SecretReference secretRef){
            _visitables.get("secretRef").remove(this.secretRef);
            if (secretRef!=null){ this.secretRef= new V1SecretReferenceBuilder(secretRef); _visitables.get("secretRef").add(this.secretRef);} return (A) this;
    }

    public Boolean hasSecretRef(){
            return this.secretRef != null;
    }

    public V1CephFSPersistentVolumeSourceFluent.SecretRefNested<A> withNewSecretRef(){
            return new SecretRefNestedImpl();
    }

    public V1CephFSPersistentVolumeSourceFluent.SecretRefNested<A> withNewSecretRefLike(V1SecretReference item){
            return new SecretRefNestedImpl(item);
    }

    public V1CephFSPersistentVolumeSourceFluent.SecretRefNested<A> editSecretRef(){
            return withNewSecretRefLike(getSecretRef());
    }

    public V1CephFSPersistentVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRef(){
            return withNewSecretRefLike(getSecretRef() != null ? getSecretRef(): new V1SecretReferenceBuilder().build());
    }

    public V1CephFSPersistentVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRefLike(V1SecretReference item){
            return withNewSecretRefLike(getSecretRef() != null ? getSecretRef(): item);
    }

    public String getUser(){
            return this.user;
    }

    public A withUser(String user){
            this.user=user; return (A) this;
    }

    public Boolean hasUser(){
            return this.user != null;
    }

    public A withNewUser(String arg1){
            return (A)withUser(new String(arg1));
    }

    public A withNewUser(StringBuilder arg1){
            return (A)withUser(new String(arg1));
    }

    public A withNewUser(StringBuffer arg1){
            return (A)withUser(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1CephFSPersistentVolumeSourceFluentImpl that = (V1CephFSPersistentVolumeSourceFluentImpl) o;
            if (monitors != null ? !monitors.equals(that.monitors) :that.monitors != null) return false;
            if (path != null ? !path.equals(that.path) :that.path != null) return false;
            if (readOnly != null ? !readOnly.equals(that.readOnly) :that.readOnly != null) return false;
            if (secretFile != null ? !secretFile.equals(that.secretFile) :that.secretFile != null) return false;
            if (secretRef != null ? !secretRef.equals(that.secretRef) :that.secretRef != null) return false;
            if (user != null ? !user.equals(that.user) :that.user != null) return false;
            return true;
    }


    public class SecretRefNestedImpl<N> extends V1SecretReferenceFluentImpl<V1CephFSPersistentVolumeSourceFluent.SecretRefNested<N>> implements V1CephFSPersistentVolumeSourceFluent.SecretRefNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1SecretReferenceBuilder builder;
    
            SecretRefNestedImpl(V1SecretReference item){
                    this.builder = new V1SecretReferenceBuilder(this, item);
            }
            SecretRefNestedImpl(){
                    this.builder = new V1SecretReferenceBuilder(this);
            }
    
    public N and(){
            return (N) V1CephFSPersistentVolumeSourceFluentImpl.this.withSecretRef(builder.build());
    }
    public N endSecretRef(){
            return and();
    }

}


}
