package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1ComponentConditionBuilder extends V1ComponentConditionFluentImpl<V1ComponentConditionBuilder> implements VisitableBuilder<V1ComponentCondition,V1ComponentConditionBuilder>{

    V1ComponentConditionFluent<?> fluent;
    Boolean validationEnabled;

    public V1ComponentConditionBuilder(){
            this(true);
    }
    public V1ComponentConditionBuilder(Boolean validationEnabled){
            this(new V1ComponentCondition(), validationEnabled);
    }
    public V1ComponentConditionBuilder(V1ComponentConditionFluent<?> fluent){
            this(fluent, true);
    }
    public V1ComponentConditionBuilder(V1ComponentConditionFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1ComponentCondition(), validationEnabled);
    }
    public V1ComponentConditionBuilder(V1ComponentConditionFluent<?> fluent,V1ComponentCondition instance){
            this(fluent, instance, true);
    }
    public V1ComponentConditionBuilder(V1ComponentConditionFluent<?> fluent,V1ComponentCondition instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withError(instance.getError());

            fluent.withMessage(instance.getMessage());

            fluent.withStatus(instance.getStatus());

            fluent.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }
    public V1ComponentConditionBuilder(V1ComponentCondition instance){
            this(instance,true);
    }
    public V1ComponentConditionBuilder(V1ComponentCondition instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withError(instance.getError());

            this.withMessage(instance.getMessage());

            this.withStatus(instance.getStatus());

            this.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }

    public V1ComponentCondition build(){
            V1ComponentCondition buildable = new V1ComponentCondition();
            buildable.setError(fluent.getError());
            buildable.setMessage(fluent.getMessage());
            buildable.setStatus(fluent.getStatus());
            buildable.setType(fluent.getType());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1ComponentConditionBuilder that = (V1ComponentConditionBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
