package io.kubernetes.client.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;

public class V1ComponentStatusFluentImpl<A extends V1ComponentStatusFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1ComponentStatusFluent<A>{

    private String apiVersion;
    private List<V1ComponentConditionBuilder> conditions;
    private String kind;
    private V1ObjectMetaBuilder metadata;

    public V1ComponentStatusFluentImpl(){
    }
    public V1ComponentStatusFluentImpl(V1ComponentStatus instance){
            this.withApiVersion(instance.getApiVersion());

            this.withConditions(instance.getConditions());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A addToConditions(int index,V1ComponentCondition item){
            if (this.conditions == null) {this.conditions = new ArrayList<V1ComponentConditionBuilder>();}
            V1ComponentConditionBuilder builder = new V1ComponentConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
    }

    public A setToConditions(int index,V1ComponentCondition item){
            if (this.conditions == null) {this.conditions = new ArrayList<V1ComponentConditionBuilder>();}
            V1ComponentConditionBuilder builder = new V1ComponentConditionBuilder(item);
            if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
            if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
             return (A)this;
    }

    public A addToConditions(V1ComponentCondition... items){
            if (this.conditions == null) {this.conditions = new ArrayList<V1ComponentConditionBuilder>();}
            for (V1ComponentCondition item : items) {V1ComponentConditionBuilder builder = new V1ComponentConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A addAllToConditions(Collection<V1ComponentCondition> items){
            if (this.conditions == null) {this.conditions = new ArrayList<V1ComponentConditionBuilder>();}
            for (V1ComponentCondition item : items) {V1ComponentConditionBuilder builder = new V1ComponentConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A removeFromConditions(V1ComponentCondition... items){
            for (V1ComponentCondition item : items) {V1ComponentConditionBuilder builder = new V1ComponentConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeAllFromConditions(Collection<V1ComponentCondition> items){
            for (V1ComponentCondition item : items) {V1ComponentConditionBuilder builder = new V1ComponentConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<V1ComponentCondition> getConditions(){
            return build(conditions);
    }

    public List<V1ComponentCondition> buildConditions(){
            return build(conditions);
    }

    public V1ComponentCondition buildCondition(int index){
            return this.conditions.get(index).build();
    }

    public V1ComponentCondition buildFirstCondition(){
            return this.conditions.get(0).build();
    }

    public V1ComponentCondition buildLastCondition(){
            return this.conditions.get(conditions.size() - 1).build();
    }

    public V1ComponentCondition buildMatchingCondition(io.kubernetes.client.fluent.Predicate<V1ComponentConditionBuilder> predicate){
            for (V1ComponentConditionBuilder item: conditions) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingCondition(io.kubernetes.client.fluent.Predicate<V1ComponentConditionBuilder> predicate){
            for (V1ComponentConditionBuilder item: conditions) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withConditions(List<V1ComponentCondition> conditions){
            if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
            if (conditions != null) {this.conditions = new ArrayList<V1ComponentConditionBuilder>(); for (V1ComponentCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
    }

    public A withConditions(V1ComponentCondition... conditions){
            if (this.conditions != null) {this.conditions.clear();}
            if (conditions != null) {for (V1ComponentCondition item :conditions){ this.addToConditions(item);}} return (A) this;
    }

    public Boolean hasConditions(){
            return conditions != null && !conditions.isEmpty();
    }

    public V1ComponentStatusFluent.ConditionsNested<A> addNewCondition(){
            return new ConditionsNestedImpl();
    }

    public V1ComponentStatusFluent.ConditionsNested<A> addNewConditionLike(V1ComponentCondition item){
            return new ConditionsNestedImpl(-1, item);
    }

    public V1ComponentStatusFluent.ConditionsNested<A> setNewConditionLike(int index,V1ComponentCondition item){
            return new ConditionsNestedImpl(index, item);
    }

    public V1ComponentStatusFluent.ConditionsNested<A> editCondition(int index){
            if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
            return setNewConditionLike(index, buildCondition(index));
    }

    public V1ComponentStatusFluent.ConditionsNested<A> editFirstCondition(){
            if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
            return setNewConditionLike(0, buildCondition(0));
    }

    public V1ComponentStatusFluent.ConditionsNested<A> editLastCondition(){
            int index = conditions.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
            return setNewConditionLike(index, buildCondition(index));
    }

    public V1ComponentStatusFluent.ConditionsNested<A> editMatchingCondition(io.kubernetes.client.fluent.Predicate<V1ComponentConditionBuilder> predicate){
            int index = -1;
            for (int i=0;i<conditions.size();i++) { 
            if (predicate.apply(conditions.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
            return setNewConditionLike(index, buildCondition(index));
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    public A withNewKind(String arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1){
            return (A)withKind(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public V1ObjectMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public V1ObjectMeta buildMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(V1ObjectMeta metadata){
            _visitables.get("metadata").remove(this.metadata);
            if (metadata!=null){ this.metadata= new V1ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata(){
            return this.metadata != null;
    }

    public V1ComponentStatusFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public V1ComponentStatusFluent.MetadataNested<A> withNewMetadataLike(V1ObjectMeta item){
            return new MetadataNestedImpl(item);
    }

    public V1ComponentStatusFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public V1ComponentStatusFluent.MetadataNested<A> editOrNewMetadata(){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): new V1ObjectMetaBuilder().build());
    }

    public V1ComponentStatusFluent.MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1ComponentStatusFluentImpl that = (V1ComponentStatusFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            return true;
    }


    public class ConditionsNestedImpl<N> extends V1ComponentConditionFluentImpl<V1ComponentStatusFluent.ConditionsNested<N>> implements V1ComponentStatusFluent.ConditionsNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1ComponentConditionBuilder builder;
        private final int index;
    
            ConditionsNestedImpl(int index,V1ComponentCondition item){
                    this.index = index;
                    this.builder = new V1ComponentConditionBuilder(this, item);
            }
            ConditionsNestedImpl(){
                    this.index = -1;
                    this.builder = new V1ComponentConditionBuilder(this);
            }
    
    public N and(){
            return (N) V1ComponentStatusFluentImpl.this.setToConditions(index, builder.build());
    }
    public N endCondition(){
            return and();
    }

}
    public class MetadataNestedImpl<N> extends V1ObjectMetaFluentImpl<V1ComponentStatusFluent.MetadataNested<N>> implements V1ComponentStatusFluent.MetadataNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1ObjectMetaBuilder builder;
    
            MetadataNestedImpl(V1ObjectMeta item){
                    this.builder = new V1ObjectMetaBuilder(this, item);
            }
            MetadataNestedImpl(){
                    this.builder = new V1ObjectMetaBuilder(this);
            }
    
    public N and(){
            return (N) V1ComponentStatusFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}


}
