package io.kubernetes.client.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Fluent;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface V1EndpointsFluent<A extends V1EndpointsFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public V1ObjectMeta getMetadata();
    public V1ObjectMeta buildMetadata();
    public A withMetadata(V1ObjectMeta metadata);
    public Boolean hasMetadata();
    public V1EndpointsFluent.MetadataNested<A> withNewMetadata();
    public V1EndpointsFluent.MetadataNested<A> withNewMetadataLike(V1ObjectMeta item);
    public V1EndpointsFluent.MetadataNested<A> editMetadata();
    public V1EndpointsFluent.MetadataNested<A> editOrNewMetadata();
    public V1EndpointsFluent.MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item);
    public A addToSubsets(int index,V1EndpointSubset item);
    public A setToSubsets(int index,V1EndpointSubset item);
    public A addToSubsets(V1EndpointSubset... items);
    public A addAllToSubsets(Collection<V1EndpointSubset> items);
    public A removeFromSubsets(V1EndpointSubset... items);
    public A removeAllFromSubsets(Collection<V1EndpointSubset> items);
    
/**
 * This method has been deprecated, please use method buildSubsets instead.
 * @return The buildable object.
 */
@Deprecated public List<V1EndpointSubset> getSubsets();
    public List<V1EndpointSubset> buildSubsets();
    public V1EndpointSubset buildSubset(int index);
    public V1EndpointSubset buildFirstSubset();
    public V1EndpointSubset buildLastSubset();
    public V1EndpointSubset buildMatchingSubset(io.kubernetes.client.fluent.Predicate<V1EndpointSubsetBuilder> predicate);
    public Boolean hasMatchingSubset(io.kubernetes.client.fluent.Predicate<V1EndpointSubsetBuilder> predicate);
    public A withSubsets(List<V1EndpointSubset> subsets);
    public A withSubsets(V1EndpointSubset... subsets);
    public Boolean hasSubsets();
    public V1EndpointsFluent.SubsetsNested<A> addNewSubset();
    public V1EndpointsFluent.SubsetsNested<A> addNewSubsetLike(V1EndpointSubset item);
    public V1EndpointsFluent.SubsetsNested<A> setNewSubsetLike(int index,V1EndpointSubset item);
    public V1EndpointsFluent.SubsetsNested<A> editSubset(int index);
    public V1EndpointsFluent.SubsetsNested<A> editFirstSubset();
    public V1EndpointsFluent.SubsetsNested<A> editLastSubset();
    public V1EndpointsFluent.SubsetsNested<A> editMatchingSubset(io.kubernetes.client.fluent.Predicate<V1EndpointSubsetBuilder> predicate);

    public interface MetadataNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1ObjectMetaFluent<V1EndpointsFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SubsetsNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1EndpointSubsetFluent<V1EndpointsFluent.SubsetsNested<N>>{

        
    public N and();    public N endSubset();
}


}
