package io.kubernetes.client.models;

import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import org.joda.time.DateTime;

public class V1EventSeriesFluentImpl<A extends V1EventSeriesFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1EventSeriesFluent<A>{

    private Integer count;
    private DateTime lastObservedTime;
    private String state;

    public V1EventSeriesFluentImpl(){
    }
    public V1EventSeriesFluentImpl(V1EventSeries instance){
            this.withCount(instance.getCount());

            this.withLastObservedTime(instance.getLastObservedTime());

            this.withState(instance.getState());

    }

    public Integer getCount(){
            return this.count;
    }

    public A withCount(Integer count){
            this.count=count; return (A) this;
    }

    public Boolean hasCount(){
            return this.count != null;
    }

    public DateTime getLastObservedTime(){
            return this.lastObservedTime;
    }

    public A withLastObservedTime(DateTime lastObservedTime){
            this.lastObservedTime=lastObservedTime; return (A) this;
    }

    public Boolean hasLastObservedTime(){
            return this.lastObservedTime != null;
    }

    public A withNewLastObservedTime(int arg0,int arg1,int arg2,int arg3,int arg4){
            return (A)withLastObservedTime(new DateTime(arg0, arg1, arg2, arg3, arg4));
    }

    public A withNewLastObservedTime(Object arg0){
            return (A)withLastObservedTime(new DateTime(arg0));
    }

    public A withNewLastObservedTime(long arg0){
            return (A)withLastObservedTime(new DateTime(arg0));
    }

    public String getState(){
            return this.state;
    }

    public A withState(String state){
            this.state=state; return (A) this;
    }

    public Boolean hasState(){
            return this.state != null;
    }

    public A withNewState(String arg1){
            return (A)withState(new String(arg1));
    }

    public A withNewState(StringBuilder arg1){
            return (A)withState(new String(arg1));
    }

    public A withNewState(StringBuffer arg1){
            return (A)withState(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1EventSeriesFluentImpl that = (V1EventSeriesFluentImpl) o;
            if (count != null ? !count.equals(that.count) :that.count != null) return false;
            if (lastObservedTime != null ? !lastObservedTime.equals(that.lastObservedTime) :that.lastObservedTime != null) return false;
            if (state != null ? !state.equals(that.state) :that.state != null) return false;
            return true;
    }




}
