package io.kubernetes.client.models;

import java.lang.StringBuffer;
import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class V1EventSourceFluentImpl<A extends V1EventSourceFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1EventSourceFluent<A>{

    private String component;
    private String host;

    public V1EventSourceFluentImpl(){
    }
    public V1EventSourceFluentImpl(V1EventSource instance){
            this.withComponent(instance.getComponent());

            this.withHost(instance.getHost());

    }

    public String getComponent(){
            return this.component;
    }

    public A withComponent(String component){
            this.component=component; return (A) this;
    }

    public Boolean hasComponent(){
            return this.component != null;
    }

    public A withNewComponent(String arg1){
            return (A)withComponent(new String(arg1));
    }

    public A withNewComponent(StringBuilder arg1){
            return (A)withComponent(new String(arg1));
    }

    public A withNewComponent(StringBuffer arg1){
            return (A)withComponent(new String(arg1));
    }

    public String getHost(){
            return this.host;
    }

    public A withHost(String host){
            this.host=host; return (A) this;
    }

    public Boolean hasHost(){
            return this.host != null;
    }

    public A withNewHost(String arg1){
            return (A)withHost(new String(arg1));
    }

    public A withNewHost(StringBuilder arg1){
            return (A)withHost(new String(arg1));
    }

    public A withNewHost(StringBuffer arg1){
            return (A)withHost(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1EventSourceFluentImpl that = (V1EventSourceFluentImpl) o;
            if (component != null ? !component.equals(that.component) :that.component != null) return false;
            if (host != null ? !host.equals(that.host) :that.host != null) return false;
            return true;
    }




}
