package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1ExecActionBuilder extends V1ExecActionFluentImpl<V1ExecActionBuilder> implements VisitableBuilder<V1ExecAction,V1ExecActionBuilder>{

    V1ExecActionFluent<?> fluent;
    Boolean validationEnabled;

    public V1ExecActionBuilder(){
            this(true);
    }
    public V1ExecActionBuilder(Boolean validationEnabled){
            this(new V1ExecAction(), validationEnabled);
    }
    public V1ExecActionBuilder(V1ExecActionFluent<?> fluent){
            this(fluent, true);
    }
    public V1ExecActionBuilder(V1ExecActionFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1ExecAction(), validationEnabled);
    }
    public V1ExecActionBuilder(V1ExecActionFluent<?> fluent,V1ExecAction instance){
            this(fluent, instance, true);
    }
    public V1ExecActionBuilder(V1ExecActionFluent<?> fluent,V1ExecAction instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withCommand(instance.getCommand());

            this.validationEnabled = validationEnabled; 
    }
    public V1ExecActionBuilder(V1ExecAction instance){
            this(instance,true);
    }
    public V1ExecActionBuilder(V1ExecAction instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withCommand(instance.getCommand());

            this.validationEnabled = validationEnabled; 
    }

    public V1ExecAction build(){
            V1ExecAction buildable = new V1ExecAction();
            buildable.setCommand(fluent.getCommand());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1ExecActionBuilder that = (V1ExecActionBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
