package io.kubernetes.client.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Boolean;
import java.lang.StringBuffer;
import java.lang.Object;

public class V1JobFluentImpl<A extends V1JobFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1JobFluent<A>{

    private String apiVersion;
    private String kind;
    private V1ObjectMetaBuilder metadata;
    private V1JobSpecBuilder spec;
    private V1JobStatusBuilder status;

    public V1JobFluentImpl(){
    }
    public V1JobFluentImpl(V1Job instance){
            this.withApiVersion(instance.getApiVersion());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.withSpec(instance.getSpec());

            this.withStatus(instance.getStatus());

    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    public A withNewKind(String arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1){
            return (A)withKind(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public V1ObjectMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public V1ObjectMeta buildMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(V1ObjectMeta metadata){
            _visitables.get("metadata").remove(this.metadata);
            if (metadata!=null){ this.metadata= new V1ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata(){
            return this.metadata != null;
    }

    public V1JobFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public V1JobFluent.MetadataNested<A> withNewMetadataLike(V1ObjectMeta item){
            return new MetadataNestedImpl(item);
    }

    public V1JobFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public V1JobFluent.MetadataNested<A> editOrNewMetadata(){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): new V1ObjectMetaBuilder().build());
    }

    public V1JobFluent.MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public V1JobSpec getSpec(){
            return this.spec!=null?this.spec.build():null;
    }

    public V1JobSpec buildSpec(){
            return this.spec!=null?this.spec.build():null;
    }

    public A withSpec(V1JobSpec spec){
            _visitables.get("spec").remove(this.spec);
            if (spec!=null){ this.spec= new V1JobSpecBuilder(spec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public Boolean hasSpec(){
            return this.spec != null;
    }

    public V1JobFluent.SpecNested<A> withNewSpec(){
            return new SpecNestedImpl();
    }

    public V1JobFluent.SpecNested<A> withNewSpecLike(V1JobSpec item){
            return new SpecNestedImpl(item);
    }

    public V1JobFluent.SpecNested<A> editSpec(){
            return withNewSpecLike(getSpec());
    }

    public V1JobFluent.SpecNested<A> editOrNewSpec(){
            return withNewSpecLike(getSpec() != null ? getSpec(): new V1JobSpecBuilder().build());
    }

    public V1JobFluent.SpecNested<A> editOrNewSpecLike(V1JobSpec item){
            return withNewSpecLike(getSpec() != null ? getSpec(): item);
    }

    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public V1JobStatus getStatus(){
            return this.status!=null?this.status.build():null;
    }

    public V1JobStatus buildStatus(){
            return this.status!=null?this.status.build():null;
    }

    public A withStatus(V1JobStatus status){
            _visitables.get("status").remove(this.status);
            if (status!=null){ this.status= new V1JobStatusBuilder(status); _visitables.get("status").add(this.status);} return (A) this;
    }

    public Boolean hasStatus(){
            return this.status != null;
    }

    public V1JobFluent.StatusNested<A> withNewStatus(){
            return new StatusNestedImpl();
    }

    public V1JobFluent.StatusNested<A> withNewStatusLike(V1JobStatus item){
            return new StatusNestedImpl(item);
    }

    public V1JobFluent.StatusNested<A> editStatus(){
            return withNewStatusLike(getStatus());
    }

    public V1JobFluent.StatusNested<A> editOrNewStatus(){
            return withNewStatusLike(getStatus() != null ? getStatus(): new V1JobStatusBuilder().build());
    }

    public V1JobFluent.StatusNested<A> editOrNewStatusLike(V1JobStatus item){
            return withNewStatusLike(getStatus() != null ? getStatus(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1JobFluentImpl that = (V1JobFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
            if (status != null ? !status.equals(that.status) :that.status != null) return false;
            return true;
    }


    public class MetadataNestedImpl<N> extends V1ObjectMetaFluentImpl<V1JobFluent.MetadataNested<N>> implements V1JobFluent.MetadataNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1ObjectMetaBuilder builder;
    
            MetadataNestedImpl(V1ObjectMeta item){
                    this.builder = new V1ObjectMetaBuilder(this, item);
            }
            MetadataNestedImpl(){
                    this.builder = new V1ObjectMetaBuilder(this);
            }
    
    public N and(){
            return (N) V1JobFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}
    public class SpecNestedImpl<N> extends V1JobSpecFluentImpl<V1JobFluent.SpecNested<N>> implements V1JobFluent.SpecNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1JobSpecBuilder builder;
    
            SpecNestedImpl(V1JobSpec item){
                    this.builder = new V1JobSpecBuilder(this, item);
            }
            SpecNestedImpl(){
                    this.builder = new V1JobSpecBuilder(this);
            }
    
    public N and(){
            return (N) V1JobFluentImpl.this.withSpec(builder.build());
    }
    public N endSpec(){
            return and();
    }

}
    public class StatusNestedImpl<N> extends V1JobStatusFluentImpl<V1JobFluent.StatusNested<N>> implements V1JobFluent.StatusNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1JobStatusBuilder builder;
    
            StatusNestedImpl(V1JobStatus item){
                    this.builder = new V1JobStatusBuilder(this, item);
            }
            StatusNestedImpl(){
                    this.builder = new V1JobStatusBuilder(this);
            }
    
    public N and(){
            return (N) V1JobFluentImpl.this.withStatus(builder.build());
    }
    public N endStatus(){
            return and();
    }

}


}
