package io.kubernetes.client.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Fluent;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface V1JobListFluent<A extends V1JobListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,V1Job item);
    public A setToItems(int index,V1Job item);
    public A addToItems(V1Job... items);
    public A addAllToItems(Collection<V1Job> items);
    public A removeFromItems(V1Job... items);
    public A removeAllFromItems(Collection<V1Job> items);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<V1Job> getItems();
    public List<V1Job> buildItems();
    public V1Job buildItem(int index);
    public V1Job buildFirstItem();
    public V1Job buildLastItem();
    public V1Job buildMatchingItem(io.kubernetes.client.fluent.Predicate<V1JobBuilder> predicate);
    public Boolean hasMatchingItem(io.kubernetes.client.fluent.Predicate<V1JobBuilder> predicate);
    public A withItems(List<V1Job> items);
    public A withItems(V1Job... items);
    public Boolean hasItems();
    public V1JobListFluent.ItemsNested<A> addNewItem();
    public V1JobListFluent.ItemsNested<A> addNewItemLike(V1Job item);
    public V1JobListFluent.ItemsNested<A> setNewItemLike(int index,V1Job item);
    public V1JobListFluent.ItemsNested<A> editItem(int index);
    public V1JobListFluent.ItemsNested<A> editFirstItem();
    public V1JobListFluent.ItemsNested<A> editLastItem();
    public V1JobListFluent.ItemsNested<A> editMatchingItem(io.kubernetes.client.fluent.Predicate<V1JobBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public V1ListMeta getMetadata();
    public V1ListMeta buildMetadata();
    public A withMetadata(V1ListMeta metadata);
    public Boolean hasMetadata();
    public V1JobListFluent.MetadataNested<A> withNewMetadata();
    public V1JobListFluent.MetadataNested<A> withNewMetadataLike(V1ListMeta item);
    public V1JobListFluent.MetadataNested<A> editMetadata();
    public V1JobListFluent.MetadataNested<A> editOrNewMetadata();
    public V1JobListFluent.MetadataNested<A> editOrNewMetadataLike(V1ListMeta item);

    public interface ItemsNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1JobFluent<V1JobListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}
    public interface MetadataNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1ListMetaFluent<V1JobListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
