package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.lang.String;
import java.lang.Integer;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Long;
import java.lang.Object;
import java.lang.Boolean;

public class V1JobSpecFluentImpl<A extends V1JobSpecFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1JobSpecFluent<A>{

    private Long activeDeadlineSeconds;
    private Integer backoffLimit;
    private Integer completions;
    private Boolean manualSelector;
    private Integer parallelism;
    private V1LabelSelectorBuilder selector;
    private V1PodTemplateSpecBuilder template;
    private Integer ttlSecondsAfterFinished;

    public V1JobSpecFluentImpl(){
    }
    public V1JobSpecFluentImpl(V1JobSpec instance){
            this.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds());

            this.withBackoffLimit(instance.getBackoffLimit());

            this.withCompletions(instance.getCompletions());

            this.withManualSelector(instance.isManualSelector());

            this.withParallelism(instance.getParallelism());

            this.withSelector(instance.getSelector());

            this.withTemplate(instance.getTemplate());

            this.withTtlSecondsAfterFinished(instance.getTtlSecondsAfterFinished());

    }

    public Long getActiveDeadlineSeconds(){
            return this.activeDeadlineSeconds;
    }

    public A withActiveDeadlineSeconds(Long activeDeadlineSeconds){
            this.activeDeadlineSeconds=activeDeadlineSeconds; return (A) this;
    }

    public Boolean hasActiveDeadlineSeconds(){
            return this.activeDeadlineSeconds != null;
    }

    public Integer getBackoffLimit(){
            return this.backoffLimit;
    }

    public A withBackoffLimit(Integer backoffLimit){
            this.backoffLimit=backoffLimit; return (A) this;
    }

    public Boolean hasBackoffLimit(){
            return this.backoffLimit != null;
    }

    public Integer getCompletions(){
            return this.completions;
    }

    public A withCompletions(Integer completions){
            this.completions=completions; return (A) this;
    }

    public Boolean hasCompletions(){
            return this.completions != null;
    }

    public Boolean isManualSelector(){
            return this.manualSelector;
    }

    public A withManualSelector(Boolean manualSelector){
            this.manualSelector=manualSelector; return (A) this;
    }

    public Boolean hasManualSelector(){
            return this.manualSelector != null;
    }

    public A withNewManualSelector(String arg1){
            return (A)withManualSelector(new Boolean(arg1));
    }

    public A withNewManualSelector(boolean arg1){
            return (A)withManualSelector(new Boolean(arg1));
    }

    public Integer getParallelism(){
            return this.parallelism;
    }

    public A withParallelism(Integer parallelism){
            this.parallelism=parallelism; return (A) this;
    }

    public Boolean hasParallelism(){
            return this.parallelism != null;
    }

    
/**
 * This method has been deprecated, please use method buildSelector instead.
 * @return The buildable object.
 */
@Deprecated public V1LabelSelector getSelector(){
            return this.selector!=null?this.selector.build():null;
    }

    public V1LabelSelector buildSelector(){
            return this.selector!=null?this.selector.build():null;
    }

    public A withSelector(V1LabelSelector selector){
            _visitables.get("selector").remove(this.selector);
            if (selector!=null){ this.selector= new V1LabelSelectorBuilder(selector); _visitables.get("selector").add(this.selector);} return (A) this;
    }

    public Boolean hasSelector(){
            return this.selector != null;
    }

    public V1JobSpecFluent.SelectorNested<A> withNewSelector(){
            return new SelectorNestedImpl();
    }

    public V1JobSpecFluent.SelectorNested<A> withNewSelectorLike(V1LabelSelector item){
            return new SelectorNestedImpl(item);
    }

    public V1JobSpecFluent.SelectorNested<A> editSelector(){
            return withNewSelectorLike(getSelector());
    }

    public V1JobSpecFluent.SelectorNested<A> editOrNewSelector(){
            return withNewSelectorLike(getSelector() != null ? getSelector(): new V1LabelSelectorBuilder().build());
    }

    public V1JobSpecFluent.SelectorNested<A> editOrNewSelectorLike(V1LabelSelector item){
            return withNewSelectorLike(getSelector() != null ? getSelector(): item);
    }

    
/**
 * This method has been deprecated, please use method buildTemplate instead.
 * @return The buildable object.
 */
@Deprecated public V1PodTemplateSpec getTemplate(){
            return this.template!=null?this.template.build():null;
    }

    public V1PodTemplateSpec buildTemplate(){
            return this.template!=null?this.template.build():null;
    }

    public A withTemplate(V1PodTemplateSpec template){
            _visitables.get("template").remove(this.template);
            if (template!=null){ this.template= new V1PodTemplateSpecBuilder(template); _visitables.get("template").add(this.template);} return (A) this;
    }

    public Boolean hasTemplate(){
            return this.template != null;
    }

    public V1JobSpecFluent.TemplateNested<A> withNewTemplate(){
            return new TemplateNestedImpl();
    }

    public V1JobSpecFluent.TemplateNested<A> withNewTemplateLike(V1PodTemplateSpec item){
            return new TemplateNestedImpl(item);
    }

    public V1JobSpecFluent.TemplateNested<A> editTemplate(){
            return withNewTemplateLike(getTemplate());
    }

    public V1JobSpecFluent.TemplateNested<A> editOrNewTemplate(){
            return withNewTemplateLike(getTemplate() != null ? getTemplate(): new V1PodTemplateSpecBuilder().build());
    }

    public V1JobSpecFluent.TemplateNested<A> editOrNewTemplateLike(V1PodTemplateSpec item){
            return withNewTemplateLike(getTemplate() != null ? getTemplate(): item);
    }

    public Integer getTtlSecondsAfterFinished(){
            return this.ttlSecondsAfterFinished;
    }

    public A withTtlSecondsAfterFinished(Integer ttlSecondsAfterFinished){
            this.ttlSecondsAfterFinished=ttlSecondsAfterFinished; return (A) this;
    }

    public Boolean hasTtlSecondsAfterFinished(){
            return this.ttlSecondsAfterFinished != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1JobSpecFluentImpl that = (V1JobSpecFluentImpl) o;
            if (activeDeadlineSeconds != null ? !activeDeadlineSeconds.equals(that.activeDeadlineSeconds) :that.activeDeadlineSeconds != null) return false;
            if (backoffLimit != null ? !backoffLimit.equals(that.backoffLimit) :that.backoffLimit != null) return false;
            if (completions != null ? !completions.equals(that.completions) :that.completions != null) return false;
            if (manualSelector != null ? !manualSelector.equals(that.manualSelector) :that.manualSelector != null) return false;
            if (parallelism != null ? !parallelism.equals(that.parallelism) :that.parallelism != null) return false;
            if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
            if (template != null ? !template.equals(that.template) :that.template != null) return false;
            if (ttlSecondsAfterFinished != null ? !ttlSecondsAfterFinished.equals(that.ttlSecondsAfterFinished) :that.ttlSecondsAfterFinished != null) return false;
            return true;
    }


    public class SelectorNestedImpl<N> extends V1LabelSelectorFluentImpl<V1JobSpecFluent.SelectorNested<N>> implements V1JobSpecFluent.SelectorNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1LabelSelectorBuilder builder;
    
            SelectorNestedImpl(V1LabelSelector item){
                    this.builder = new V1LabelSelectorBuilder(this, item);
            }
            SelectorNestedImpl(){
                    this.builder = new V1LabelSelectorBuilder(this);
            }
    
    public N and(){
            return (N) V1JobSpecFluentImpl.this.withSelector(builder.build());
    }
    public N endSelector(){
            return and();
    }

}
    public class TemplateNestedImpl<N> extends V1PodTemplateSpecFluentImpl<V1JobSpecFluent.TemplateNested<N>> implements V1JobSpecFluent.TemplateNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1PodTemplateSpecBuilder builder;
    
            TemplateNestedImpl(V1PodTemplateSpec item){
                    this.builder = new V1PodTemplateSpecBuilder(this, item);
            }
            TemplateNestedImpl(){
                    this.builder = new V1PodTemplateSpecBuilder(this);
            }
    
    public N and(){
            return (N) V1JobSpecFluentImpl.this.withTemplate(builder.build());
    }
    public N endTemplate(){
            return and();
    }

}


}
