package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1NFSVolumeSourceBuilder extends V1NFSVolumeSourceFluentImpl<V1NFSVolumeSourceBuilder> implements VisitableBuilder<V1NFSVolumeSource,V1NFSVolumeSourceBuilder>{

    V1NFSVolumeSourceFluent<?> fluent;
    Boolean validationEnabled;

    public V1NFSVolumeSourceBuilder(){
            this(true);
    }
    public V1NFSVolumeSourceBuilder(Boolean validationEnabled){
            this(new V1NFSVolumeSource(), validationEnabled);
    }
    public V1NFSVolumeSourceBuilder(V1NFSVolumeSourceFluent<?> fluent){
            this(fluent, true);
    }
    public V1NFSVolumeSourceBuilder(V1NFSVolumeSourceFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1NFSVolumeSource(), validationEnabled);
    }
    public V1NFSVolumeSourceBuilder(V1NFSVolumeSourceFluent<?> fluent,V1NFSVolumeSource instance){
            this(fluent, instance, true);
    }
    public V1NFSVolumeSourceBuilder(V1NFSVolumeSourceFluent<?> fluent,V1NFSVolumeSource instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withPath(instance.getPath());

            fluent.withReadOnly(instance.isReadOnly());

            fluent.withServer(instance.getServer());

            this.validationEnabled = validationEnabled; 
    }
    public V1NFSVolumeSourceBuilder(V1NFSVolumeSource instance){
            this(instance,true);
    }
    public V1NFSVolumeSourceBuilder(V1NFSVolumeSource instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withPath(instance.getPath());

            this.withReadOnly(instance.isReadOnly());

            this.withServer(instance.getServer());

            this.validationEnabled = validationEnabled; 
    }

    public V1NFSVolumeSource build(){
            V1NFSVolumeSource buildable = new V1NFSVolumeSource();
            buildable.setPath(fluent.getPath());
            buildable.setReadOnly(fluent.isReadOnly());
            buildable.setServer(fluent.getServer());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1NFSVolumeSourceBuilder that = (V1NFSVolumeSourceBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
