package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1NetworkPolicyPeerBuilder extends V1NetworkPolicyPeerFluentImpl<V1NetworkPolicyPeerBuilder> implements VisitableBuilder<V1NetworkPolicyPeer,V1NetworkPolicyPeerBuilder>{

    V1NetworkPolicyPeerFluent<?> fluent;
    Boolean validationEnabled;

    public V1NetworkPolicyPeerBuilder(){
            this(true);
    }
    public V1NetworkPolicyPeerBuilder(Boolean validationEnabled){
            this(new V1NetworkPolicyPeer(), validationEnabled);
    }
    public V1NetworkPolicyPeerBuilder(V1NetworkPolicyPeerFluent<?> fluent){
            this(fluent, true);
    }
    public V1NetworkPolicyPeerBuilder(V1NetworkPolicyPeerFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1NetworkPolicyPeer(), validationEnabled);
    }
    public V1NetworkPolicyPeerBuilder(V1NetworkPolicyPeerFluent<?> fluent,V1NetworkPolicyPeer instance){
            this(fluent, instance, true);
    }
    public V1NetworkPolicyPeerBuilder(V1NetworkPolicyPeerFluent<?> fluent,V1NetworkPolicyPeer instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withIpBlock(instance.getIpBlock());

            fluent.withNamespaceSelector(instance.getNamespaceSelector());

            fluent.withPodSelector(instance.getPodSelector());

            this.validationEnabled = validationEnabled; 
    }
    public V1NetworkPolicyPeerBuilder(V1NetworkPolicyPeer instance){
            this(instance,true);
    }
    public V1NetworkPolicyPeerBuilder(V1NetworkPolicyPeer instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withIpBlock(instance.getIpBlock());

            this.withNamespaceSelector(instance.getNamespaceSelector());

            this.withPodSelector(instance.getPodSelector());

            this.validationEnabled = validationEnabled; 
    }

    public V1NetworkPolicyPeer build(){
            V1NetworkPolicyPeer buildable = new V1NetworkPolicyPeer();
            buildable.setIpBlock(fluent.getIpBlock());
            buildable.setNamespaceSelector(fluent.getNamespaceSelector());
            buildable.setPodSelector(fluent.getPodSelector());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1NetworkPolicyPeerBuilder that = (V1NetworkPolicyPeerBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
