package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class V1NodeSelectorFluentImpl<A extends V1NodeSelectorFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1NodeSelectorFluent<A>{

    private List<V1NodeSelectorTermBuilder> nodeSelectorTerms;

    public V1NodeSelectorFluentImpl(){
    }
    public V1NodeSelectorFluentImpl(V1NodeSelector instance){
            this.withNodeSelectorTerms(instance.getNodeSelectorTerms());

    }

    public A addToNodeSelectorTerms(int index,V1NodeSelectorTerm item){
            if (this.nodeSelectorTerms == null) {this.nodeSelectorTerms = new ArrayList<V1NodeSelectorTermBuilder>();}
            V1NodeSelectorTermBuilder builder = new V1NodeSelectorTermBuilder(item);_visitables.get("nodeSelectorTerms").add(index >= 0 ? index : _visitables.get("nodeSelectorTerms").size(), builder);this.nodeSelectorTerms.add(index >= 0 ? index : nodeSelectorTerms.size(), builder); return (A)this;
    }

    public A setToNodeSelectorTerms(int index,V1NodeSelectorTerm item){
            if (this.nodeSelectorTerms == null) {this.nodeSelectorTerms = new ArrayList<V1NodeSelectorTermBuilder>();}
            V1NodeSelectorTermBuilder builder = new V1NodeSelectorTermBuilder(item);
            if (index < 0 || index >= _visitables.get("nodeSelectorTerms").size()) { _visitables.get("nodeSelectorTerms").add(builder); } else { _visitables.get("nodeSelectorTerms").set(index, builder);}
            if (index < 0 || index >= nodeSelectorTerms.size()) { nodeSelectorTerms.add(builder); } else { nodeSelectorTerms.set(index, builder);}
             return (A)this;
    }

    public A addToNodeSelectorTerms(V1NodeSelectorTerm... items){
            if (this.nodeSelectorTerms == null) {this.nodeSelectorTerms = new ArrayList<V1NodeSelectorTermBuilder>();}
            for (V1NodeSelectorTerm item : items) {V1NodeSelectorTermBuilder builder = new V1NodeSelectorTermBuilder(item);_visitables.get("nodeSelectorTerms").add(builder);this.nodeSelectorTerms.add(builder);} return (A)this;
    }

    public A addAllToNodeSelectorTerms(Collection<V1NodeSelectorTerm> items){
            if (this.nodeSelectorTerms == null) {this.nodeSelectorTerms = new ArrayList<V1NodeSelectorTermBuilder>();}
            for (V1NodeSelectorTerm item : items) {V1NodeSelectorTermBuilder builder = new V1NodeSelectorTermBuilder(item);_visitables.get("nodeSelectorTerms").add(builder);this.nodeSelectorTerms.add(builder);} return (A)this;
    }

    public A removeFromNodeSelectorTerms(V1NodeSelectorTerm... items){
            for (V1NodeSelectorTerm item : items) {V1NodeSelectorTermBuilder builder = new V1NodeSelectorTermBuilder(item);_visitables.get("nodeSelectorTerms").remove(builder);if (this.nodeSelectorTerms != null) {this.nodeSelectorTerms.remove(builder);}} return (A)this;
    }

    public A removeAllFromNodeSelectorTerms(Collection<V1NodeSelectorTerm> items){
            for (V1NodeSelectorTerm item : items) {V1NodeSelectorTermBuilder builder = new V1NodeSelectorTermBuilder(item);_visitables.get("nodeSelectorTerms").remove(builder);if (this.nodeSelectorTerms != null) {this.nodeSelectorTerms.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildNodeSelectorTerms instead.
 * @return The buildable object.
 */
@Deprecated public List<V1NodeSelectorTerm> getNodeSelectorTerms(){
            return build(nodeSelectorTerms);
    }

    public List<V1NodeSelectorTerm> buildNodeSelectorTerms(){
            return build(nodeSelectorTerms);
    }

    public V1NodeSelectorTerm buildNodeSelectorTerm(int index){
            return this.nodeSelectorTerms.get(index).build();
    }

    public V1NodeSelectorTerm buildFirstNodeSelectorTerm(){
            return this.nodeSelectorTerms.get(0).build();
    }

    public V1NodeSelectorTerm buildLastNodeSelectorTerm(){
            return this.nodeSelectorTerms.get(nodeSelectorTerms.size() - 1).build();
    }

    public V1NodeSelectorTerm buildMatchingNodeSelectorTerm(io.kubernetes.client.fluent.Predicate<V1NodeSelectorTermBuilder> predicate){
            for (V1NodeSelectorTermBuilder item: nodeSelectorTerms) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingNodeSelectorTerm(io.kubernetes.client.fluent.Predicate<V1NodeSelectorTermBuilder> predicate){
            for (V1NodeSelectorTermBuilder item: nodeSelectorTerms) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withNodeSelectorTerms(List<V1NodeSelectorTerm> nodeSelectorTerms){
            if (this.nodeSelectorTerms != null) { _visitables.get("nodeSelectorTerms").removeAll(this.nodeSelectorTerms);}
            if (nodeSelectorTerms != null) {this.nodeSelectorTerms = new ArrayList<V1NodeSelectorTermBuilder>(); for (V1NodeSelectorTerm item : nodeSelectorTerms){this.addToNodeSelectorTerms(item);}} else { this.nodeSelectorTerms = null;} return (A) this;
    }

    public A withNodeSelectorTerms(V1NodeSelectorTerm... nodeSelectorTerms){
            if (this.nodeSelectorTerms != null) {this.nodeSelectorTerms.clear();}
            if (nodeSelectorTerms != null) {for (V1NodeSelectorTerm item :nodeSelectorTerms){ this.addToNodeSelectorTerms(item);}} return (A) this;
    }

    public Boolean hasNodeSelectorTerms(){
            return nodeSelectorTerms != null && !nodeSelectorTerms.isEmpty();
    }

    public V1NodeSelectorFluent.NodeSelectorTermsNested<A> addNewNodeSelectorTerm(){
            return new NodeSelectorTermsNestedImpl();
    }

    public V1NodeSelectorFluent.NodeSelectorTermsNested<A> addNewNodeSelectorTermLike(V1NodeSelectorTerm item){
            return new NodeSelectorTermsNestedImpl(-1, item);
    }

    public V1NodeSelectorFluent.NodeSelectorTermsNested<A> setNewNodeSelectorTermLike(int index,V1NodeSelectorTerm item){
            return new NodeSelectorTermsNestedImpl(index, item);
    }

    public V1NodeSelectorFluent.NodeSelectorTermsNested<A> editNodeSelectorTerm(int index){
            if (nodeSelectorTerms.size() <= index) throw new RuntimeException("Can't edit nodeSelectorTerms. Index exceeds size.");
            return setNewNodeSelectorTermLike(index, buildNodeSelectorTerm(index));
    }

    public V1NodeSelectorFluent.NodeSelectorTermsNested<A> editFirstNodeSelectorTerm(){
            if (nodeSelectorTerms.size() == 0) throw new RuntimeException("Can't edit first nodeSelectorTerms. The list is empty.");
            return setNewNodeSelectorTermLike(0, buildNodeSelectorTerm(0));
    }

    public V1NodeSelectorFluent.NodeSelectorTermsNested<A> editLastNodeSelectorTerm(){
            int index = nodeSelectorTerms.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last nodeSelectorTerms. The list is empty.");
            return setNewNodeSelectorTermLike(index, buildNodeSelectorTerm(index));
    }

    public V1NodeSelectorFluent.NodeSelectorTermsNested<A> editMatchingNodeSelectorTerm(io.kubernetes.client.fluent.Predicate<V1NodeSelectorTermBuilder> predicate){
            int index = -1;
            for (int i=0;i<nodeSelectorTerms.size();i++) { 
            if (predicate.apply(nodeSelectorTerms.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching nodeSelectorTerms. No match found.");
            return setNewNodeSelectorTermLike(index, buildNodeSelectorTerm(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1NodeSelectorFluentImpl that = (V1NodeSelectorFluentImpl) o;
            if (nodeSelectorTerms != null ? !nodeSelectorTerms.equals(that.nodeSelectorTerms) :that.nodeSelectorTerms != null) return false;
            return true;
    }


    public class NodeSelectorTermsNestedImpl<N> extends V1NodeSelectorTermFluentImpl<V1NodeSelectorFluent.NodeSelectorTermsNested<N>> implements V1NodeSelectorFluent.NodeSelectorTermsNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1NodeSelectorTermBuilder builder;
        private final int index;
    
            NodeSelectorTermsNestedImpl(int index,V1NodeSelectorTerm item){
                    this.index = index;
                    this.builder = new V1NodeSelectorTermBuilder(this, item);
            }
            NodeSelectorTermsNestedImpl(){
                    this.index = -1;
                    this.builder = new V1NodeSelectorTermBuilder(this);
            }
    
    public N and(){
            return (N) V1NodeSelectorFluentImpl.this.setToNodeSelectorTerms(index, builder.build());
    }
    public N endNodeSelectorTerm(){
            return and();
    }

}


}
