package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class V1NodeSelectorTermFluentImpl<A extends V1NodeSelectorTermFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1NodeSelectorTermFluent<A>{

    private List<V1NodeSelectorRequirementBuilder> matchExpressions;
    private List<V1NodeSelectorRequirementBuilder> matchFields;

    public V1NodeSelectorTermFluentImpl(){
    }
    public V1NodeSelectorTermFluentImpl(V1NodeSelectorTerm instance){
            this.withMatchExpressions(instance.getMatchExpressions());

            this.withMatchFields(instance.getMatchFields());

    }

    public A addToMatchExpressions(int index,V1NodeSelectorRequirement item){
            if (this.matchExpressions == null) {this.matchExpressions = new ArrayList<V1NodeSelectorRequirementBuilder>();}
            V1NodeSelectorRequirementBuilder builder = new V1NodeSelectorRequirementBuilder(item);_visitables.get("matchExpressions").add(index >= 0 ? index : _visitables.get("matchExpressions").size(), builder);this.matchExpressions.add(index >= 0 ? index : matchExpressions.size(), builder); return (A)this;
    }

    public A setToMatchExpressions(int index,V1NodeSelectorRequirement item){
            if (this.matchExpressions == null) {this.matchExpressions = new ArrayList<V1NodeSelectorRequirementBuilder>();}
            V1NodeSelectorRequirementBuilder builder = new V1NodeSelectorRequirementBuilder(item);
            if (index < 0 || index >= _visitables.get("matchExpressions").size()) { _visitables.get("matchExpressions").add(builder); } else { _visitables.get("matchExpressions").set(index, builder);}
            if (index < 0 || index >= matchExpressions.size()) { matchExpressions.add(builder); } else { matchExpressions.set(index, builder);}
             return (A)this;
    }

    public A addToMatchExpressions(V1NodeSelectorRequirement... items){
            if (this.matchExpressions == null) {this.matchExpressions = new ArrayList<V1NodeSelectorRequirementBuilder>();}
            for (V1NodeSelectorRequirement item : items) {V1NodeSelectorRequirementBuilder builder = new V1NodeSelectorRequirementBuilder(item);_visitables.get("matchExpressions").add(builder);this.matchExpressions.add(builder);} return (A)this;
    }

    public A addAllToMatchExpressions(Collection<V1NodeSelectorRequirement> items){
            if (this.matchExpressions == null) {this.matchExpressions = new ArrayList<V1NodeSelectorRequirementBuilder>();}
            for (V1NodeSelectorRequirement item : items) {V1NodeSelectorRequirementBuilder builder = new V1NodeSelectorRequirementBuilder(item);_visitables.get("matchExpressions").add(builder);this.matchExpressions.add(builder);} return (A)this;
    }

    public A removeFromMatchExpressions(V1NodeSelectorRequirement... items){
            for (V1NodeSelectorRequirement item : items) {V1NodeSelectorRequirementBuilder builder = new V1NodeSelectorRequirementBuilder(item);_visitables.get("matchExpressions").remove(builder);if (this.matchExpressions != null) {this.matchExpressions.remove(builder);}} return (A)this;
    }

    public A removeAllFromMatchExpressions(Collection<V1NodeSelectorRequirement> items){
            for (V1NodeSelectorRequirement item : items) {V1NodeSelectorRequirementBuilder builder = new V1NodeSelectorRequirementBuilder(item);_visitables.get("matchExpressions").remove(builder);if (this.matchExpressions != null) {this.matchExpressions.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildMatchExpressions instead.
 * @return The buildable object.
 */
@Deprecated public List<V1NodeSelectorRequirement> getMatchExpressions(){
            return build(matchExpressions);
    }

    public List<V1NodeSelectorRequirement> buildMatchExpressions(){
            return build(matchExpressions);
    }

    public V1NodeSelectorRequirement buildMatchExpression(int index){
            return this.matchExpressions.get(index).build();
    }

    public V1NodeSelectorRequirement buildFirstMatchExpression(){
            return this.matchExpressions.get(0).build();
    }

    public V1NodeSelectorRequirement buildLastMatchExpression(){
            return this.matchExpressions.get(matchExpressions.size() - 1).build();
    }

    public V1NodeSelectorRequirement buildMatchingMatchExpression(io.kubernetes.client.fluent.Predicate<V1NodeSelectorRequirementBuilder> predicate){
            for (V1NodeSelectorRequirementBuilder item: matchExpressions) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingMatchExpression(io.kubernetes.client.fluent.Predicate<V1NodeSelectorRequirementBuilder> predicate){
            for (V1NodeSelectorRequirementBuilder item: matchExpressions) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withMatchExpressions(List<V1NodeSelectorRequirement> matchExpressions){
            if (this.matchExpressions != null) { _visitables.get("matchExpressions").removeAll(this.matchExpressions);}
            if (matchExpressions != null) {this.matchExpressions = new ArrayList<V1NodeSelectorRequirementBuilder>(); for (V1NodeSelectorRequirement item : matchExpressions){this.addToMatchExpressions(item);}} else { this.matchExpressions = null;} return (A) this;
    }

    public A withMatchExpressions(V1NodeSelectorRequirement... matchExpressions){
            if (this.matchExpressions != null) {this.matchExpressions.clear();}
            if (matchExpressions != null) {for (V1NodeSelectorRequirement item :matchExpressions){ this.addToMatchExpressions(item);}} return (A) this;
    }

    public Boolean hasMatchExpressions(){
            return matchExpressions != null && !matchExpressions.isEmpty();
    }

    public V1NodeSelectorTermFluent.MatchExpressionsNested<A> addNewMatchExpression(){
            return new MatchExpressionsNestedImpl();
    }

    public V1NodeSelectorTermFluent.MatchExpressionsNested<A> addNewMatchExpressionLike(V1NodeSelectorRequirement item){
            return new MatchExpressionsNestedImpl(-1, item);
    }

    public V1NodeSelectorTermFluent.MatchExpressionsNested<A> setNewMatchExpressionLike(int index,V1NodeSelectorRequirement item){
            return new MatchExpressionsNestedImpl(index, item);
    }

    public V1NodeSelectorTermFluent.MatchExpressionsNested<A> editMatchExpression(int index){
            if (matchExpressions.size() <= index) throw new RuntimeException("Can't edit matchExpressions. Index exceeds size.");
            return setNewMatchExpressionLike(index, buildMatchExpression(index));
    }

    public V1NodeSelectorTermFluent.MatchExpressionsNested<A> editFirstMatchExpression(){
            if (matchExpressions.size() == 0) throw new RuntimeException("Can't edit first matchExpressions. The list is empty.");
            return setNewMatchExpressionLike(0, buildMatchExpression(0));
    }

    public V1NodeSelectorTermFluent.MatchExpressionsNested<A> editLastMatchExpression(){
            int index = matchExpressions.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last matchExpressions. The list is empty.");
            return setNewMatchExpressionLike(index, buildMatchExpression(index));
    }

    public V1NodeSelectorTermFluent.MatchExpressionsNested<A> editMatchingMatchExpression(io.kubernetes.client.fluent.Predicate<V1NodeSelectorRequirementBuilder> predicate){
            int index = -1;
            for (int i=0;i<matchExpressions.size();i++) { 
            if (predicate.apply(matchExpressions.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching matchExpressions. No match found.");
            return setNewMatchExpressionLike(index, buildMatchExpression(index));
    }

    public A addToMatchFields(int index,V1NodeSelectorRequirement item){
            if (this.matchFields == null) {this.matchFields = new ArrayList<V1NodeSelectorRequirementBuilder>();}
            V1NodeSelectorRequirementBuilder builder = new V1NodeSelectorRequirementBuilder(item);_visitables.get("matchFields").add(index >= 0 ? index : _visitables.get("matchFields").size(), builder);this.matchFields.add(index >= 0 ? index : matchFields.size(), builder); return (A)this;
    }

    public A setToMatchFields(int index,V1NodeSelectorRequirement item){
            if (this.matchFields == null) {this.matchFields = new ArrayList<V1NodeSelectorRequirementBuilder>();}
            V1NodeSelectorRequirementBuilder builder = new V1NodeSelectorRequirementBuilder(item);
            if (index < 0 || index >= _visitables.get("matchFields").size()) { _visitables.get("matchFields").add(builder); } else { _visitables.get("matchFields").set(index, builder);}
            if (index < 0 || index >= matchFields.size()) { matchFields.add(builder); } else { matchFields.set(index, builder);}
             return (A)this;
    }

    public A addToMatchFields(V1NodeSelectorRequirement... items){
            if (this.matchFields == null) {this.matchFields = new ArrayList<V1NodeSelectorRequirementBuilder>();}
            for (V1NodeSelectorRequirement item : items) {V1NodeSelectorRequirementBuilder builder = new V1NodeSelectorRequirementBuilder(item);_visitables.get("matchFields").add(builder);this.matchFields.add(builder);} return (A)this;
    }

    public A addAllToMatchFields(Collection<V1NodeSelectorRequirement> items){
            if (this.matchFields == null) {this.matchFields = new ArrayList<V1NodeSelectorRequirementBuilder>();}
            for (V1NodeSelectorRequirement item : items) {V1NodeSelectorRequirementBuilder builder = new V1NodeSelectorRequirementBuilder(item);_visitables.get("matchFields").add(builder);this.matchFields.add(builder);} return (A)this;
    }

    public A removeFromMatchFields(V1NodeSelectorRequirement... items){
            for (V1NodeSelectorRequirement item : items) {V1NodeSelectorRequirementBuilder builder = new V1NodeSelectorRequirementBuilder(item);_visitables.get("matchFields").remove(builder);if (this.matchFields != null) {this.matchFields.remove(builder);}} return (A)this;
    }

    public A removeAllFromMatchFields(Collection<V1NodeSelectorRequirement> items){
            for (V1NodeSelectorRequirement item : items) {V1NodeSelectorRequirementBuilder builder = new V1NodeSelectorRequirementBuilder(item);_visitables.get("matchFields").remove(builder);if (this.matchFields != null) {this.matchFields.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildMatchFields instead.
 * @return The buildable object.
 */
@Deprecated public List<V1NodeSelectorRequirement> getMatchFields(){
            return build(matchFields);
    }

    public List<V1NodeSelectorRequirement> buildMatchFields(){
            return build(matchFields);
    }

    public V1NodeSelectorRequirement buildMatchField(int index){
            return this.matchFields.get(index).build();
    }

    public V1NodeSelectorRequirement buildFirstMatchField(){
            return this.matchFields.get(0).build();
    }

    public V1NodeSelectorRequirement buildLastMatchField(){
            return this.matchFields.get(matchFields.size() - 1).build();
    }

    public V1NodeSelectorRequirement buildMatchingMatchField(io.kubernetes.client.fluent.Predicate<V1NodeSelectorRequirementBuilder> predicate){
            for (V1NodeSelectorRequirementBuilder item: matchFields) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingMatchField(io.kubernetes.client.fluent.Predicate<V1NodeSelectorRequirementBuilder> predicate){
            for (V1NodeSelectorRequirementBuilder item: matchFields) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withMatchFields(List<V1NodeSelectorRequirement> matchFields){
            if (this.matchFields != null) { _visitables.get("matchFields").removeAll(this.matchFields);}
            if (matchFields != null) {this.matchFields = new ArrayList<V1NodeSelectorRequirementBuilder>(); for (V1NodeSelectorRequirement item : matchFields){this.addToMatchFields(item);}} else { this.matchFields = null;} return (A) this;
    }

    public A withMatchFields(V1NodeSelectorRequirement... matchFields){
            if (this.matchFields != null) {this.matchFields.clear();}
            if (matchFields != null) {for (V1NodeSelectorRequirement item :matchFields){ this.addToMatchFields(item);}} return (A) this;
    }

    public Boolean hasMatchFields(){
            return matchFields != null && !matchFields.isEmpty();
    }

    public V1NodeSelectorTermFluent.MatchFieldsNested<A> addNewMatchField(){
            return new MatchFieldsNestedImpl();
    }

    public V1NodeSelectorTermFluent.MatchFieldsNested<A> addNewMatchFieldLike(V1NodeSelectorRequirement item){
            return new MatchFieldsNestedImpl(-1, item);
    }

    public V1NodeSelectorTermFluent.MatchFieldsNested<A> setNewMatchFieldLike(int index,V1NodeSelectorRequirement item){
            return new MatchFieldsNestedImpl(index, item);
    }

    public V1NodeSelectorTermFluent.MatchFieldsNested<A> editMatchField(int index){
            if (matchFields.size() <= index) throw new RuntimeException("Can't edit matchFields. Index exceeds size.");
            return setNewMatchFieldLike(index, buildMatchField(index));
    }

    public V1NodeSelectorTermFluent.MatchFieldsNested<A> editFirstMatchField(){
            if (matchFields.size() == 0) throw new RuntimeException("Can't edit first matchFields. The list is empty.");
            return setNewMatchFieldLike(0, buildMatchField(0));
    }

    public V1NodeSelectorTermFluent.MatchFieldsNested<A> editLastMatchField(){
            int index = matchFields.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last matchFields. The list is empty.");
            return setNewMatchFieldLike(index, buildMatchField(index));
    }

    public V1NodeSelectorTermFluent.MatchFieldsNested<A> editMatchingMatchField(io.kubernetes.client.fluent.Predicate<V1NodeSelectorRequirementBuilder> predicate){
            int index = -1;
            for (int i=0;i<matchFields.size();i++) { 
            if (predicate.apply(matchFields.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching matchFields. No match found.");
            return setNewMatchFieldLike(index, buildMatchField(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1NodeSelectorTermFluentImpl that = (V1NodeSelectorTermFluentImpl) o;
            if (matchExpressions != null ? !matchExpressions.equals(that.matchExpressions) :that.matchExpressions != null) return false;
            if (matchFields != null ? !matchFields.equals(that.matchFields) :that.matchFields != null) return false;
            return true;
    }


    public class MatchExpressionsNestedImpl<N> extends V1NodeSelectorRequirementFluentImpl<V1NodeSelectorTermFluent.MatchExpressionsNested<N>> implements V1NodeSelectorTermFluent.MatchExpressionsNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1NodeSelectorRequirementBuilder builder;
        private final int index;
    
            MatchExpressionsNestedImpl(int index,V1NodeSelectorRequirement item){
                    this.index = index;
                    this.builder = new V1NodeSelectorRequirementBuilder(this, item);
            }
            MatchExpressionsNestedImpl(){
                    this.index = -1;
                    this.builder = new V1NodeSelectorRequirementBuilder(this);
            }
    
    public N and(){
            return (N) V1NodeSelectorTermFluentImpl.this.setToMatchExpressions(index, builder.build());
    }
    public N endMatchExpression(){
            return and();
    }

}
    public class MatchFieldsNestedImpl<N> extends V1NodeSelectorRequirementFluentImpl<V1NodeSelectorTermFluent.MatchFieldsNested<N>> implements V1NodeSelectorTermFluent.MatchFieldsNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1NodeSelectorRequirementBuilder builder;
        private final int index;
    
            MatchFieldsNestedImpl(int index,V1NodeSelectorRequirement item){
                    this.index = index;
                    this.builder = new V1NodeSelectorRequirementBuilder(this, item);
            }
            MatchFieldsNestedImpl(){
                    this.index = -1;
                    this.builder = new V1NodeSelectorRequirementBuilder(this);
            }
    
    public N and(){
            return (N) V1NodeSelectorTermFluentImpl.this.setToMatchFields(index, builder.build());
    }
    public N endMatchField(){
            return and();
    }

}


}
