package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1PersistentVolumeClaimVolumeSourceBuilder extends V1PersistentVolumeClaimVolumeSourceFluentImpl<V1PersistentVolumeClaimVolumeSourceBuilder> implements VisitableBuilder<V1PersistentVolumeClaimVolumeSource,V1PersistentVolumeClaimVolumeSourceBuilder>{

    V1PersistentVolumeClaimVolumeSourceFluent<?> fluent;
    Boolean validationEnabled;

    public V1PersistentVolumeClaimVolumeSourceBuilder(){
            this(true);
    }
    public V1PersistentVolumeClaimVolumeSourceBuilder(Boolean validationEnabled){
            this(new V1PersistentVolumeClaimVolumeSource(), validationEnabled);
    }
    public V1PersistentVolumeClaimVolumeSourceBuilder(V1PersistentVolumeClaimVolumeSourceFluent<?> fluent){
            this(fluent, true);
    }
    public V1PersistentVolumeClaimVolumeSourceBuilder(V1PersistentVolumeClaimVolumeSourceFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1PersistentVolumeClaimVolumeSource(), validationEnabled);
    }
    public V1PersistentVolumeClaimVolumeSourceBuilder(V1PersistentVolumeClaimVolumeSourceFluent<?> fluent,V1PersistentVolumeClaimVolumeSource instance){
            this(fluent, instance, true);
    }
    public V1PersistentVolumeClaimVolumeSourceBuilder(V1PersistentVolumeClaimVolumeSourceFluent<?> fluent,V1PersistentVolumeClaimVolumeSource instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withClaimName(instance.getClaimName());

            fluent.withReadOnly(instance.isReadOnly());

            this.validationEnabled = validationEnabled; 
    }
    public V1PersistentVolumeClaimVolumeSourceBuilder(V1PersistentVolumeClaimVolumeSource instance){
            this(instance,true);
    }
    public V1PersistentVolumeClaimVolumeSourceBuilder(V1PersistentVolumeClaimVolumeSource instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withClaimName(instance.getClaimName());

            this.withReadOnly(instance.isReadOnly());

            this.validationEnabled = validationEnabled; 
    }

    public V1PersistentVolumeClaimVolumeSource build(){
            V1PersistentVolumeClaimVolumeSource buildable = new V1PersistentVolumeClaimVolumeSource();
            buildable.setClaimName(fluent.getClaimName());
            buildable.setReadOnly(fluent.isReadOnly());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1PersistentVolumeClaimVolumeSourceBuilder that = (V1PersistentVolumeClaimVolumeSourceBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
