package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Fluent;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface V1PodSecurityContextFluent<A extends V1PodSecurityContextFluent<A>> extends Fluent<A>{


    public Long getFsGroup();
    public A withFsGroup(Long fsGroup);
    public Boolean hasFsGroup();
    public Long getRunAsGroup();
    public A withRunAsGroup(Long runAsGroup);
    public Boolean hasRunAsGroup();
    public Boolean isRunAsNonRoot();
    public A withRunAsNonRoot(Boolean runAsNonRoot);
    public Boolean hasRunAsNonRoot();
    public A withNewRunAsNonRoot(String arg1);
    public A withNewRunAsNonRoot(boolean arg1);
    public Long getRunAsUser();
    public A withRunAsUser(Long runAsUser);
    public Boolean hasRunAsUser();
    
/**
 * This method has been deprecated, please use method buildSeLinuxOptions instead.
 * @return The buildable object.
 */
@Deprecated public V1SELinuxOptions getSeLinuxOptions();
    public V1SELinuxOptions buildSeLinuxOptions();
    public A withSeLinuxOptions(V1SELinuxOptions seLinuxOptions);
    public Boolean hasSeLinuxOptions();
    public V1PodSecurityContextFluent.SeLinuxOptionsNested<A> withNewSeLinuxOptions();
    public V1PodSecurityContextFluent.SeLinuxOptionsNested<A> withNewSeLinuxOptionsLike(V1SELinuxOptions item);
    public V1PodSecurityContextFluent.SeLinuxOptionsNested<A> editSeLinuxOptions();
    public V1PodSecurityContextFluent.SeLinuxOptionsNested<A> editOrNewSeLinuxOptions();
    public V1PodSecurityContextFluent.SeLinuxOptionsNested<A> editOrNewSeLinuxOptionsLike(V1SELinuxOptions item);
    public A addToSupplementalGroups(int index,Long item);
    public A setToSupplementalGroups(int index,Long item);
    public A addToSupplementalGroups(Long... items);
    public A addAllToSupplementalGroups(Collection<Long> items);
    public A removeFromSupplementalGroups(Long... items);
    public A removeAllFromSupplementalGroups(Collection<Long> items);
    public List<Long> getSupplementalGroups();
    public Long getSupplementalGroup(int index);
    public Long getFirstSupplementalGroup();
    public Long getLastSupplementalGroup();
    public Long getMatchingSupplementalGroup(io.kubernetes.client.fluent.Predicate<Long> predicate);
    public Boolean hasMatchingSupplementalGroup(io.kubernetes.client.fluent.Predicate<Long> predicate);
    public A withSupplementalGroups(List<Long> supplementalGroups);
    public A withSupplementalGroups(Long... supplementalGroups);
    public Boolean hasSupplementalGroups();
    public A addToSysctls(int index,V1Sysctl item);
    public A setToSysctls(int index,V1Sysctl item);
    public A addToSysctls(V1Sysctl... items);
    public A addAllToSysctls(Collection<V1Sysctl> items);
    public A removeFromSysctls(V1Sysctl... items);
    public A removeAllFromSysctls(Collection<V1Sysctl> items);
    
/**
 * This method has been deprecated, please use method buildSysctls instead.
 * @return The buildable object.
 */
@Deprecated public List<V1Sysctl> getSysctls();
    public List<V1Sysctl> buildSysctls();
    public V1Sysctl buildSysctl(int index);
    public V1Sysctl buildFirstSysctl();
    public V1Sysctl buildLastSysctl();
    public V1Sysctl buildMatchingSysctl(io.kubernetes.client.fluent.Predicate<V1SysctlBuilder> predicate);
    public Boolean hasMatchingSysctl(io.kubernetes.client.fluent.Predicate<V1SysctlBuilder> predicate);
    public A withSysctls(List<V1Sysctl> sysctls);
    public A withSysctls(V1Sysctl... sysctls);
    public Boolean hasSysctls();
    public V1PodSecurityContextFluent.SysctlsNested<A> addNewSysctl();
    public V1PodSecurityContextFluent.SysctlsNested<A> addNewSysctlLike(V1Sysctl item);
    public V1PodSecurityContextFluent.SysctlsNested<A> setNewSysctlLike(int index,V1Sysctl item);
    public V1PodSecurityContextFluent.SysctlsNested<A> editSysctl(int index);
    public V1PodSecurityContextFluent.SysctlsNested<A> editFirstSysctl();
    public V1PodSecurityContextFluent.SysctlsNested<A> editLastSysctl();
    public V1PodSecurityContextFluent.SysctlsNested<A> editMatchingSysctl(io.kubernetes.client.fluent.Predicate<V1SysctlBuilder> predicate);

    public interface SeLinuxOptionsNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1SELinuxOptionsFluent<V1PodSecurityContextFluent.SeLinuxOptionsNested<N>>{

        
    public N and();    public N endSeLinuxOptions();
}
    public interface SysctlsNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1SysctlFluent<V1PodSecurityContextFluent.SysctlsNested<N>>{

        
    public N and();    public N endSysctl();
}


}
