package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1PreferredSchedulingTermBuilder extends V1PreferredSchedulingTermFluentImpl<V1PreferredSchedulingTermBuilder> implements VisitableBuilder<V1PreferredSchedulingTerm,V1PreferredSchedulingTermBuilder>{

    V1PreferredSchedulingTermFluent<?> fluent;
    Boolean validationEnabled;

    public V1PreferredSchedulingTermBuilder(){
            this(true);
    }
    public V1PreferredSchedulingTermBuilder(Boolean validationEnabled){
            this(new V1PreferredSchedulingTerm(), validationEnabled);
    }
    public V1PreferredSchedulingTermBuilder(V1PreferredSchedulingTermFluent<?> fluent){
            this(fluent, true);
    }
    public V1PreferredSchedulingTermBuilder(V1PreferredSchedulingTermFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1PreferredSchedulingTerm(), validationEnabled);
    }
    public V1PreferredSchedulingTermBuilder(V1PreferredSchedulingTermFluent<?> fluent,V1PreferredSchedulingTerm instance){
            this(fluent, instance, true);
    }
    public V1PreferredSchedulingTermBuilder(V1PreferredSchedulingTermFluent<?> fluent,V1PreferredSchedulingTerm instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withPreference(instance.getPreference());

            fluent.withWeight(instance.getWeight());

            this.validationEnabled = validationEnabled; 
    }
    public V1PreferredSchedulingTermBuilder(V1PreferredSchedulingTerm instance){
            this(instance,true);
    }
    public V1PreferredSchedulingTermBuilder(V1PreferredSchedulingTerm instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withPreference(instance.getPreference());

            this.withWeight(instance.getWeight());

            this.validationEnabled = validationEnabled; 
    }

    public V1PreferredSchedulingTerm build(){
            V1PreferredSchedulingTerm buildable = new V1PreferredSchedulingTerm();
            buildable.setPreference(fluent.getPreference());
            buildable.setWeight(fluent.getWeight());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1PreferredSchedulingTermBuilder that = (V1PreferredSchedulingTermBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
