package io.kubernetes.client.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Fluent;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface V1ReplicationControllerListFluent<A extends V1ReplicationControllerListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,V1ReplicationController item);
    public A setToItems(int index,V1ReplicationController item);
    public A addToItems(V1ReplicationController... items);
    public A addAllToItems(Collection<V1ReplicationController> items);
    public A removeFromItems(V1ReplicationController... items);
    public A removeAllFromItems(Collection<V1ReplicationController> items);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<V1ReplicationController> getItems();
    public List<V1ReplicationController> buildItems();
    public V1ReplicationController buildItem(int index);
    public V1ReplicationController buildFirstItem();
    public V1ReplicationController buildLastItem();
    public V1ReplicationController buildMatchingItem(io.kubernetes.client.fluent.Predicate<V1ReplicationControllerBuilder> predicate);
    public Boolean hasMatchingItem(io.kubernetes.client.fluent.Predicate<V1ReplicationControllerBuilder> predicate);
    public A withItems(List<V1ReplicationController> items);
    public A withItems(V1ReplicationController... items);
    public Boolean hasItems();
    public V1ReplicationControllerListFluent.ItemsNested<A> addNewItem();
    public V1ReplicationControllerListFluent.ItemsNested<A> addNewItemLike(V1ReplicationController item);
    public V1ReplicationControllerListFluent.ItemsNested<A> setNewItemLike(int index,V1ReplicationController item);
    public V1ReplicationControllerListFluent.ItemsNested<A> editItem(int index);
    public V1ReplicationControllerListFluent.ItemsNested<A> editFirstItem();
    public V1ReplicationControllerListFluent.ItemsNested<A> editLastItem();
    public V1ReplicationControllerListFluent.ItemsNested<A> editMatchingItem(io.kubernetes.client.fluent.Predicate<V1ReplicationControllerBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public V1ListMeta getMetadata();
    public V1ListMeta buildMetadata();
    public A withMetadata(V1ListMeta metadata);
    public Boolean hasMetadata();
    public V1ReplicationControllerListFluent.MetadataNested<A> withNewMetadata();
    public V1ReplicationControllerListFluent.MetadataNested<A> withNewMetadataLike(V1ListMeta item);
    public V1ReplicationControllerListFluent.MetadataNested<A> editMetadata();
    public V1ReplicationControllerListFluent.MetadataNested<A> editOrNewMetadata();
    public V1ReplicationControllerListFluent.MetadataNested<A> editOrNewMetadataLike(V1ListMeta item);

    public interface ItemsNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1ReplicationControllerFluent<V1ReplicationControllerListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}
    public interface MetadataNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1ListMetaFluent<V1ReplicationControllerListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
