package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1RoleRefBuilder extends V1RoleRefFluentImpl<V1RoleRefBuilder> implements VisitableBuilder<V1RoleRef,V1RoleRefBuilder>{

    V1RoleRefFluent<?> fluent;
    Boolean validationEnabled;

    public V1RoleRefBuilder(){
            this(true);
    }
    public V1RoleRefBuilder(Boolean validationEnabled){
            this(new V1RoleRef(), validationEnabled);
    }
    public V1RoleRefBuilder(V1RoleRefFluent<?> fluent){
            this(fluent, true);
    }
    public V1RoleRefBuilder(V1RoleRefFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1RoleRef(), validationEnabled);
    }
    public V1RoleRefBuilder(V1RoleRefFluent<?> fluent,V1RoleRef instance){
            this(fluent, instance, true);
    }
    public V1RoleRefBuilder(V1RoleRefFluent<?> fluent,V1RoleRef instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiGroup(instance.getApiGroup());

            fluent.withKind(instance.getKind());

            fluent.withName(instance.getName());

            this.validationEnabled = validationEnabled; 
    }
    public V1RoleRefBuilder(V1RoleRef instance){
            this(instance,true);
    }
    public V1RoleRefBuilder(V1RoleRef instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiGroup(instance.getApiGroup());

            this.withKind(instance.getKind());

            this.withName(instance.getName());

            this.validationEnabled = validationEnabled; 
    }

    public V1RoleRef build(){
            V1RoleRef buildable = new V1RoleRef();
            buildable.setApiGroup(fluent.getApiGroup());
            buildable.setKind(fluent.getKind());
            buildable.setName(fluent.getName());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1RoleRefBuilder that = (V1RoleRefBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
