package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1ScopeSelectorBuilder extends V1ScopeSelectorFluentImpl<V1ScopeSelectorBuilder> implements VisitableBuilder<V1ScopeSelector,V1ScopeSelectorBuilder>{

    V1ScopeSelectorFluent<?> fluent;
    Boolean validationEnabled;

    public V1ScopeSelectorBuilder(){
            this(true);
    }
    public V1ScopeSelectorBuilder(Boolean validationEnabled){
            this(new V1ScopeSelector(), validationEnabled);
    }
    public V1ScopeSelectorBuilder(V1ScopeSelectorFluent<?> fluent){
            this(fluent, true);
    }
    public V1ScopeSelectorBuilder(V1ScopeSelectorFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1ScopeSelector(), validationEnabled);
    }
    public V1ScopeSelectorBuilder(V1ScopeSelectorFluent<?> fluent,V1ScopeSelector instance){
            this(fluent, instance, true);
    }
    public V1ScopeSelectorBuilder(V1ScopeSelectorFluent<?> fluent,V1ScopeSelector instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withMatchExpressions(instance.getMatchExpressions());

            this.validationEnabled = validationEnabled; 
    }
    public V1ScopeSelectorBuilder(V1ScopeSelector instance){
            this(instance,true);
    }
    public V1ScopeSelectorBuilder(V1ScopeSelector instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withMatchExpressions(instance.getMatchExpressions());

            this.validationEnabled = validationEnabled; 
    }

    public V1ScopeSelector build(){
            V1ScopeSelector buildable = new V1ScopeSelector();
            buildable.setMatchExpressions(fluent.getMatchExpressions());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1ScopeSelectorBuilder that = (V1ScopeSelectorBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
