package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1ServiceAccountListBuilder extends V1ServiceAccountListFluentImpl<V1ServiceAccountListBuilder> implements VisitableBuilder<V1ServiceAccountList,V1ServiceAccountListBuilder>{

    V1ServiceAccountListFluent<?> fluent;
    Boolean validationEnabled;

    public V1ServiceAccountListBuilder(){
            this(true);
    }
    public V1ServiceAccountListBuilder(Boolean validationEnabled){
            this(new V1ServiceAccountList(), validationEnabled);
    }
    public V1ServiceAccountListBuilder(V1ServiceAccountListFluent<?> fluent){
            this(fluent, true);
    }
    public V1ServiceAccountListBuilder(V1ServiceAccountListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1ServiceAccountList(), validationEnabled);
    }
    public V1ServiceAccountListBuilder(V1ServiceAccountListFluent<?> fluent,V1ServiceAccountList instance){
            this(fluent, instance, true);
    }
    public V1ServiceAccountListBuilder(V1ServiceAccountListFluent<?> fluent,V1ServiceAccountList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withItems(instance.getItems());

            fluent.withKind(instance.getKind());

            fluent.withMetadata(instance.getMetadata());

            this.validationEnabled = validationEnabled; 
    }
    public V1ServiceAccountListBuilder(V1ServiceAccountList instance){
            this(instance,true);
    }
    public V1ServiceAccountListBuilder(V1ServiceAccountList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withItems(instance.getItems());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.validationEnabled = validationEnabled; 
    }

    public V1ServiceAccountList build(){
            V1ServiceAccountList buildable = new V1ServiceAccountList();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setItems(fluent.getItems());
            buildable.setKind(fluent.getKind());
            buildable.setMetadata(fluent.getMetadata());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1ServiceAccountListBuilder that = (V1ServiceAccountListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
