package io.kubernetes.client.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Fluent;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.util.LinkedHashMap;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface V1ServiceSpecFluent<A extends V1ServiceSpecFluent<A>> extends Fluent<A>{


    public String getClusterIP();
    public A withClusterIP(String clusterIP);
    public Boolean hasClusterIP();
    public A withNewClusterIP(String arg1);
    public A withNewClusterIP(StringBuilder arg1);
    public A withNewClusterIP(StringBuffer arg1);
    public A addToExternalIPs(int index,String item);
    public A setToExternalIPs(int index,String item);
    public A addToExternalIPs(String... items);
    public A addAllToExternalIPs(Collection<String> items);
    public A removeFromExternalIPs(String... items);
    public A removeAllFromExternalIPs(Collection<String> items);
    public List<String> getExternalIPs();
    public String getExternalIP(int index);
    public String getFirstExternalIP();
    public String getLastExternalIP();
    public String getMatchingExternalIP(io.kubernetes.client.fluent.Predicate<String> predicate);
    public Boolean hasMatchingExternalIP(io.kubernetes.client.fluent.Predicate<String> predicate);
    public A withExternalIPs(List<String> externalIPs);
    public A withExternalIPs(String... externalIPs);
    public Boolean hasExternalIPs();
    public A addNewExternalIP(String arg1);
    public A addNewExternalIP(StringBuilder arg1);
    public A addNewExternalIP(StringBuffer arg1);
    public String getExternalName();
    public A withExternalName(String externalName);
    public Boolean hasExternalName();
    public A withNewExternalName(String arg1);
    public A withNewExternalName(StringBuilder arg1);
    public A withNewExternalName(StringBuffer arg1);
    public String getExternalTrafficPolicy();
    public A withExternalTrafficPolicy(String externalTrafficPolicy);
    public Boolean hasExternalTrafficPolicy();
    public A withNewExternalTrafficPolicy(String arg1);
    public A withNewExternalTrafficPolicy(StringBuilder arg1);
    public A withNewExternalTrafficPolicy(StringBuffer arg1);
    public Integer getHealthCheckNodePort();
    public A withHealthCheckNodePort(Integer healthCheckNodePort);
    public Boolean hasHealthCheckNodePort();
    public String getLoadBalancerIP();
    public A withLoadBalancerIP(String loadBalancerIP);
    public Boolean hasLoadBalancerIP();
    public A withNewLoadBalancerIP(String arg1);
    public A withNewLoadBalancerIP(StringBuilder arg1);
    public A withNewLoadBalancerIP(StringBuffer arg1);
    public A addToLoadBalancerSourceRanges(int index,String item);
    public A setToLoadBalancerSourceRanges(int index,String item);
    public A addToLoadBalancerSourceRanges(String... items);
    public A addAllToLoadBalancerSourceRanges(Collection<String> items);
    public A removeFromLoadBalancerSourceRanges(String... items);
    public A removeAllFromLoadBalancerSourceRanges(Collection<String> items);
    public List<String> getLoadBalancerSourceRanges();
    public String getLoadBalancerSourceRange(int index);
    public String getFirstLoadBalancerSourceRange();
    public String getLastLoadBalancerSourceRange();
    public String getMatchingLoadBalancerSourceRange(io.kubernetes.client.fluent.Predicate<String> predicate);
    public Boolean hasMatchingLoadBalancerSourceRange(io.kubernetes.client.fluent.Predicate<String> predicate);
    public A withLoadBalancerSourceRanges(List<String> loadBalancerSourceRanges);
    public A withLoadBalancerSourceRanges(String... loadBalancerSourceRanges);
    public Boolean hasLoadBalancerSourceRanges();
    public A addNewLoadBalancerSourceRange(String arg1);
    public A addNewLoadBalancerSourceRange(StringBuilder arg1);
    public A addNewLoadBalancerSourceRange(StringBuffer arg1);
    public A addToPorts(int index,V1ServicePort item);
    public A setToPorts(int index,V1ServicePort item);
    public A addToPorts(V1ServicePort... items);
    public A addAllToPorts(Collection<V1ServicePort> items);
    public A removeFromPorts(V1ServicePort... items);
    public A removeAllFromPorts(Collection<V1ServicePort> items);
    
/**
 * This method has been deprecated, please use method buildPorts instead.
 * @return The buildable object.
 */
@Deprecated public List<V1ServicePort> getPorts();
    public List<V1ServicePort> buildPorts();
    public V1ServicePort buildPort(int index);
    public V1ServicePort buildFirstPort();
    public V1ServicePort buildLastPort();
    public V1ServicePort buildMatchingPort(io.kubernetes.client.fluent.Predicate<V1ServicePortBuilder> predicate);
    public Boolean hasMatchingPort(io.kubernetes.client.fluent.Predicate<V1ServicePortBuilder> predicate);
    public A withPorts(List<V1ServicePort> ports);
    public A withPorts(V1ServicePort... ports);
    public Boolean hasPorts();
    public V1ServiceSpecFluent.PortsNested<A> addNewPort();
    public V1ServiceSpecFluent.PortsNested<A> addNewPortLike(V1ServicePort item);
    public V1ServiceSpecFluent.PortsNested<A> setNewPortLike(int index,V1ServicePort item);
    public V1ServiceSpecFluent.PortsNested<A> editPort(int index);
    public V1ServiceSpecFluent.PortsNested<A> editFirstPort();
    public V1ServiceSpecFluent.PortsNested<A> editLastPort();
    public V1ServiceSpecFluent.PortsNested<A> editMatchingPort(io.kubernetes.client.fluent.Predicate<V1ServicePortBuilder> predicate);
    public Boolean isPublishNotReadyAddresses();
    public A withPublishNotReadyAddresses(Boolean publishNotReadyAddresses);
    public Boolean hasPublishNotReadyAddresses();
    public A withNewPublishNotReadyAddresses(String arg1);
    public A withNewPublishNotReadyAddresses(boolean arg1);
    public A addToSelector(String key,String value);
    public A addToSelector(Map<String,String> map);
    public A removeFromSelector(String key);
    public A removeFromSelector(Map<String,String> map);
    public Map<String,String> getSelector();
    public A withSelector(Map<String,String> selector);
    public Boolean hasSelector();
    public String getSessionAffinity();
    public A withSessionAffinity(String sessionAffinity);
    public Boolean hasSessionAffinity();
    public A withNewSessionAffinity(String arg1);
    public A withNewSessionAffinity(StringBuilder arg1);
    public A withNewSessionAffinity(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildSessionAffinityConfig instead.
 * @return The buildable object.
 */
@Deprecated public V1SessionAffinityConfig getSessionAffinityConfig();
    public V1SessionAffinityConfig buildSessionAffinityConfig();
    public A withSessionAffinityConfig(V1SessionAffinityConfig sessionAffinityConfig);
    public Boolean hasSessionAffinityConfig();
    public V1ServiceSpecFluent.SessionAffinityConfigNested<A> withNewSessionAffinityConfig();
    public V1ServiceSpecFluent.SessionAffinityConfigNested<A> withNewSessionAffinityConfigLike(V1SessionAffinityConfig item);
    public V1ServiceSpecFluent.SessionAffinityConfigNested<A> editSessionAffinityConfig();
    public V1ServiceSpecFluent.SessionAffinityConfigNested<A> editOrNewSessionAffinityConfig();
    public V1ServiceSpecFluent.SessionAffinityConfigNested<A> editOrNewSessionAffinityConfigLike(V1SessionAffinityConfig item);
    public String getType();
    public A withType(String type);
    public Boolean hasType();
    public A withNewType(String arg1);
    public A withNewType(StringBuilder arg1);
    public A withNewType(StringBuffer arg1);

    public interface PortsNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1ServicePortFluent<V1ServiceSpecFluent.PortsNested<N>>{

        
    public N and();    public N endPort();
}
    public interface SessionAffinityConfigNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1SessionAffinityConfigFluent<V1ServiceSpecFluent.SessionAffinityConfigNested<N>>{

        
    public N and();    public N endSessionAffinityConfig();
}


}
