package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1AuditSinkSpecBuilder extends V1alpha1AuditSinkSpecFluentImpl<V1alpha1AuditSinkSpecBuilder> implements VisitableBuilder<V1alpha1AuditSinkSpec,V1alpha1AuditSinkSpecBuilder>{

    V1alpha1AuditSinkSpecFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1AuditSinkSpecBuilder(){
            this(true);
    }
    public V1alpha1AuditSinkSpecBuilder(Boolean validationEnabled){
            this(new V1alpha1AuditSinkSpec(), validationEnabled);
    }
    public V1alpha1AuditSinkSpecBuilder(V1alpha1AuditSinkSpecFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1AuditSinkSpecBuilder(V1alpha1AuditSinkSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1AuditSinkSpec(), validationEnabled);
    }
    public V1alpha1AuditSinkSpecBuilder(V1alpha1AuditSinkSpecFluent<?> fluent,V1alpha1AuditSinkSpec instance){
            this(fluent, instance, true);
    }
    public V1alpha1AuditSinkSpecBuilder(V1alpha1AuditSinkSpecFluent<?> fluent,V1alpha1AuditSinkSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withPolicy(instance.getPolicy());

            fluent.withWebhook(instance.getWebhook());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1AuditSinkSpecBuilder(V1alpha1AuditSinkSpec instance){
            this(instance,true);
    }
    public V1alpha1AuditSinkSpecBuilder(V1alpha1AuditSinkSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withPolicy(instance.getPolicy());

            this.withWebhook(instance.getWebhook());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1AuditSinkSpec build(){
            V1alpha1AuditSinkSpec buildable = new V1alpha1AuditSinkSpec();
            buildable.setPolicy(fluent.getPolicy());
            buildable.setWebhook(fluent.getWebhook());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1AuditSinkSpecBuilder that = (V1alpha1AuditSinkSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
