package io.kubernetes.client.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.StringBuffer;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class V1alpha1PolicyFluentImpl<A extends V1alpha1PolicyFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1alpha1PolicyFluent<A>{

    private String level;
    private List<String> stages;

    public V1alpha1PolicyFluentImpl(){
    }
    public V1alpha1PolicyFluentImpl(V1alpha1Policy instance){
            this.withLevel(instance.getLevel());

            this.withStages(instance.getStages());

    }

    public String getLevel(){
            return this.level;
    }

    public A withLevel(String level){
            this.level=level; return (A) this;
    }

    public Boolean hasLevel(){
            return this.level != null;
    }

    public A withNewLevel(String arg1){
            return (A)withLevel(new String(arg1));
    }

    public A withNewLevel(StringBuilder arg1){
            return (A)withLevel(new String(arg1));
    }

    public A withNewLevel(StringBuffer arg1){
            return (A)withLevel(new String(arg1));
    }

    public A addToStages(int index,String item){
            if (this.stages == null) {this.stages = new ArrayList<String>();}
            this.stages.add(index, item);
            return (A)this;
    }

    public A setToStages(int index,String item){
            if (this.stages == null) {this.stages = new ArrayList<String>();}
            this.stages.set(index, item); return (A)this;
    }

    public A addToStages(String... items){
            if (this.stages == null) {this.stages = new ArrayList<String>();}
            for (String item : items) {this.stages.add(item);} return (A)this;
    }

    public A addAllToStages(Collection<String> items){
            if (this.stages == null) {this.stages = new ArrayList<String>();}
            for (String item : items) {this.stages.add(item);} return (A)this;
    }

    public A removeFromStages(String... items){
            for (String item : items) {if (this.stages!= null){ this.stages.remove(item);}} return (A)this;
    }

    public A removeAllFromStages(Collection<String> items){
            for (String item : items) {if (this.stages!= null){ this.stages.remove(item);}} return (A)this;
    }

    public List<String> getStages(){
            return this.stages;
    }

    public String getStage(int index){
            return this.stages.get(index);
    }

    public String getFirstStage(){
            return this.stages.get(0);
    }

    public String getLastStage(){
            return this.stages.get(stages.size() - 1);
    }

    public String getMatchingStage(io.kubernetes.client.fluent.Predicate<String> predicate){
            for (String item: stages) { if(predicate.apply(item)){return item;} } return null;
    }

    public Boolean hasMatchingStage(io.kubernetes.client.fluent.Predicate<String> predicate){
            for (String item: stages) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withStages(List<String> stages){
            if (this.stages != null) { _visitables.get("stages").removeAll(this.stages);}
            if (stages != null) {this.stages = new ArrayList<String>(); for (String item : stages){this.addToStages(item);}} else { this.stages = null;} return (A) this;
    }

    public A withStages(String... stages){
            if (this.stages != null) {this.stages.clear();}
            if (stages != null) {for (String item :stages){ this.addToStages(item);}} return (A) this;
    }

    public Boolean hasStages(){
            return stages != null && !stages.isEmpty();
    }

    public A addNewStage(String arg1){
            return (A)addToStages(new String(arg1));
    }

    public A addNewStage(StringBuilder arg1){
            return (A)addToStages(new String(arg1));
    }

    public A addNewStage(StringBuffer arg1){
            return (A)addToStages(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PolicyFluentImpl that = (V1alpha1PolicyFluentImpl) o;
            if (level != null ? !level.equals(that.level) :that.level != null) return false;
            if (stages != null ? !stages.equals(that.stages) :that.stages != null) return false;
            return true;
    }




}
