package io.kubernetes.client.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Fluent;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface V1alpha1RoleListFluent<A extends V1alpha1RoleListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,V1alpha1Role item);
    public A setToItems(int index,V1alpha1Role item);
    public A addToItems(V1alpha1Role... items);
    public A addAllToItems(Collection<V1alpha1Role> items);
    public A removeFromItems(V1alpha1Role... items);
    public A removeAllFromItems(Collection<V1alpha1Role> items);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<V1alpha1Role> getItems();
    public List<V1alpha1Role> buildItems();
    public V1alpha1Role buildItem(int index);
    public V1alpha1Role buildFirstItem();
    public V1alpha1Role buildLastItem();
    public V1alpha1Role buildMatchingItem(io.kubernetes.client.fluent.Predicate<V1alpha1RoleBuilder> predicate);
    public Boolean hasMatchingItem(io.kubernetes.client.fluent.Predicate<V1alpha1RoleBuilder> predicate);
    public A withItems(List<V1alpha1Role> items);
    public A withItems(V1alpha1Role... items);
    public Boolean hasItems();
    public V1alpha1RoleListFluent.ItemsNested<A> addNewItem();
    public V1alpha1RoleListFluent.ItemsNested<A> addNewItemLike(V1alpha1Role item);
    public V1alpha1RoleListFluent.ItemsNested<A> setNewItemLike(int index,V1alpha1Role item);
    public V1alpha1RoleListFluent.ItemsNested<A> editItem(int index);
    public V1alpha1RoleListFluent.ItemsNested<A> editFirstItem();
    public V1alpha1RoleListFluent.ItemsNested<A> editLastItem();
    public V1alpha1RoleListFluent.ItemsNested<A> editMatchingItem(io.kubernetes.client.fluent.Predicate<V1alpha1RoleBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public V1ListMeta getMetadata();
    public V1ListMeta buildMetadata();
    public A withMetadata(V1ListMeta metadata);
    public Boolean hasMetadata();
    public V1alpha1RoleListFluent.MetadataNested<A> withNewMetadata();
    public V1alpha1RoleListFluent.MetadataNested<A> withNewMetadataLike(V1ListMeta item);
    public V1alpha1RoleListFluent.MetadataNested<A> editMetadata();
    public V1alpha1RoleListFluent.MetadataNested<A> editOrNewMetadata();
    public V1alpha1RoleListFluent.MetadataNested<A> editOrNewMetadataLike(V1ListMeta item);

    public interface ItemsNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1alpha1RoleFluent<V1alpha1RoleListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}
    public interface MetadataNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1ListMetaFluent<V1alpha1RoleListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
