package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1ServiceReferenceBuilder extends V1alpha1ServiceReferenceFluentImpl<V1alpha1ServiceReferenceBuilder> implements VisitableBuilder<V1alpha1ServiceReference,V1alpha1ServiceReferenceBuilder>{

    V1alpha1ServiceReferenceFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1ServiceReferenceBuilder(){
            this(true);
    }
    public V1alpha1ServiceReferenceBuilder(Boolean validationEnabled){
            this(new V1alpha1ServiceReference(), validationEnabled);
    }
    public V1alpha1ServiceReferenceBuilder(V1alpha1ServiceReferenceFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1ServiceReferenceBuilder(V1alpha1ServiceReferenceFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1ServiceReference(), validationEnabled);
    }
    public V1alpha1ServiceReferenceBuilder(V1alpha1ServiceReferenceFluent<?> fluent,V1alpha1ServiceReference instance){
            this(fluent, instance, true);
    }
    public V1alpha1ServiceReferenceBuilder(V1alpha1ServiceReferenceFluent<?> fluent,V1alpha1ServiceReference instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withName(instance.getName());

            fluent.withNamespace(instance.getNamespace());

            fluent.withPath(instance.getPath());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1ServiceReferenceBuilder(V1alpha1ServiceReference instance){
            this(instance,true);
    }
    public V1alpha1ServiceReferenceBuilder(V1alpha1ServiceReference instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withName(instance.getName());

            this.withNamespace(instance.getNamespace());

            this.withPath(instance.getPath());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1ServiceReference build(){
            V1alpha1ServiceReference buildable = new V1alpha1ServiceReference();
            buildable.setName(fluent.getName());
            buildable.setNamespace(fluent.getNamespace());
            buildable.setPath(fluent.getPath());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1ServiceReferenceBuilder that = (V1alpha1ServiceReferenceBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
