package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1WebhookBuilder extends V1alpha1WebhookFluentImpl<V1alpha1WebhookBuilder> implements VisitableBuilder<V1alpha1Webhook,V1alpha1WebhookBuilder>{

    V1alpha1WebhookFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1WebhookBuilder(){
            this(true);
    }
    public V1alpha1WebhookBuilder(Boolean validationEnabled){
            this(new V1alpha1Webhook(), validationEnabled);
    }
    public V1alpha1WebhookBuilder(V1alpha1WebhookFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1WebhookBuilder(V1alpha1WebhookFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1Webhook(), validationEnabled);
    }
    public V1alpha1WebhookBuilder(V1alpha1WebhookFluent<?> fluent,V1alpha1Webhook instance){
            this(fluent, instance, true);
    }
    public V1alpha1WebhookBuilder(V1alpha1WebhookFluent<?> fluent,V1alpha1Webhook instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withClientConfig(instance.getClientConfig());

            fluent.withThrottle(instance.getThrottle());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1WebhookBuilder(V1alpha1Webhook instance){
            this(instance,true);
    }
    public V1alpha1WebhookBuilder(V1alpha1Webhook instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withClientConfig(instance.getClientConfig());

            this.withThrottle(instance.getThrottle());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1Webhook build(){
            V1alpha1Webhook buildable = new V1alpha1Webhook();
            buildable.setClientConfig(fluent.getClientConfig());
            buildable.setThrottle(fluent.getThrottle());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1WebhookBuilder that = (V1alpha1WebhookBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
