package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1WebhookFluentImpl<A extends V1alpha1WebhookFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1alpha1WebhookFluent<A>{

    private V1alpha1WebhookClientConfigBuilder clientConfig;
    private V1alpha1WebhookThrottleConfigBuilder throttle;

    public V1alpha1WebhookFluentImpl(){
    }
    public V1alpha1WebhookFluentImpl(V1alpha1Webhook instance){
            this.withClientConfig(instance.getClientConfig());

            this.withThrottle(instance.getThrottle());

    }

    
/**
 * This method has been deprecated, please use method buildClientConfig instead.
 * @return The buildable object.
 */
@Deprecated public V1alpha1WebhookClientConfig getClientConfig(){
            return this.clientConfig!=null?this.clientConfig.build():null;
    }

    public V1alpha1WebhookClientConfig buildClientConfig(){
            return this.clientConfig!=null?this.clientConfig.build():null;
    }

    public A withClientConfig(V1alpha1WebhookClientConfig clientConfig){
            _visitables.get("clientConfig").remove(this.clientConfig);
            if (clientConfig!=null){ this.clientConfig= new V1alpha1WebhookClientConfigBuilder(clientConfig); _visitables.get("clientConfig").add(this.clientConfig);} return (A) this;
    }

    public Boolean hasClientConfig(){
            return this.clientConfig != null;
    }

    public V1alpha1WebhookFluent.ClientConfigNested<A> withNewClientConfig(){
            return new ClientConfigNestedImpl();
    }

    public V1alpha1WebhookFluent.ClientConfigNested<A> withNewClientConfigLike(V1alpha1WebhookClientConfig item){
            return new ClientConfigNestedImpl(item);
    }

    public V1alpha1WebhookFluent.ClientConfigNested<A> editClientConfig(){
            return withNewClientConfigLike(getClientConfig());
    }

    public V1alpha1WebhookFluent.ClientConfigNested<A> editOrNewClientConfig(){
            return withNewClientConfigLike(getClientConfig() != null ? getClientConfig(): new V1alpha1WebhookClientConfigBuilder().build());
    }

    public V1alpha1WebhookFluent.ClientConfigNested<A> editOrNewClientConfigLike(V1alpha1WebhookClientConfig item){
            return withNewClientConfigLike(getClientConfig() != null ? getClientConfig(): item);
    }

    
/**
 * This method has been deprecated, please use method buildThrottle instead.
 * @return The buildable object.
 */
@Deprecated public V1alpha1WebhookThrottleConfig getThrottle(){
            return this.throttle!=null?this.throttle.build():null;
    }

    public V1alpha1WebhookThrottleConfig buildThrottle(){
            return this.throttle!=null?this.throttle.build():null;
    }

    public A withThrottle(V1alpha1WebhookThrottleConfig throttle){
            _visitables.get("throttle").remove(this.throttle);
            if (throttle!=null){ this.throttle= new V1alpha1WebhookThrottleConfigBuilder(throttle); _visitables.get("throttle").add(this.throttle);} return (A) this;
    }

    public Boolean hasThrottle(){
            return this.throttle != null;
    }

    public V1alpha1WebhookFluent.ThrottleNested<A> withNewThrottle(){
            return new ThrottleNestedImpl();
    }

    public V1alpha1WebhookFluent.ThrottleNested<A> withNewThrottleLike(V1alpha1WebhookThrottleConfig item){
            return new ThrottleNestedImpl(item);
    }

    public V1alpha1WebhookFluent.ThrottleNested<A> editThrottle(){
            return withNewThrottleLike(getThrottle());
    }

    public V1alpha1WebhookFluent.ThrottleNested<A> editOrNewThrottle(){
            return withNewThrottleLike(getThrottle() != null ? getThrottle(): new V1alpha1WebhookThrottleConfigBuilder().build());
    }

    public V1alpha1WebhookFluent.ThrottleNested<A> editOrNewThrottleLike(V1alpha1WebhookThrottleConfig item){
            return withNewThrottleLike(getThrottle() != null ? getThrottle(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1WebhookFluentImpl that = (V1alpha1WebhookFluentImpl) o;
            if (clientConfig != null ? !clientConfig.equals(that.clientConfig) :that.clientConfig != null) return false;
            if (throttle != null ? !throttle.equals(that.throttle) :that.throttle != null) return false;
            return true;
    }


    public class ClientConfigNestedImpl<N> extends V1alpha1WebhookClientConfigFluentImpl<V1alpha1WebhookFluent.ClientConfigNested<N>> implements V1alpha1WebhookFluent.ClientConfigNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1alpha1WebhookClientConfigBuilder builder;
    
            ClientConfigNestedImpl(V1alpha1WebhookClientConfig item){
                    this.builder = new V1alpha1WebhookClientConfigBuilder(this, item);
            }
            ClientConfigNestedImpl(){
                    this.builder = new V1alpha1WebhookClientConfigBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1WebhookFluentImpl.this.withClientConfig(builder.build());
    }
    public N endClientConfig(){
            return and();
    }

}
    public class ThrottleNestedImpl<N> extends V1alpha1WebhookThrottleConfigFluentImpl<V1alpha1WebhookFluent.ThrottleNested<N>> implements V1alpha1WebhookFluent.ThrottleNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1alpha1WebhookThrottleConfigBuilder builder;
    
            ThrottleNestedImpl(V1alpha1WebhookThrottleConfig item){
                    this.builder = new V1alpha1WebhookThrottleConfigBuilder(this, item);
            }
            ThrottleNestedImpl(){
                    this.builder = new V1alpha1WebhookThrottleConfigBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1WebhookFluentImpl.this.withThrottle(builder.build());
    }
    public N endThrottle(){
            return and();
    }

}


}
