package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1WebhookThrottleConfigBuilder extends V1alpha1WebhookThrottleConfigFluentImpl<V1alpha1WebhookThrottleConfigBuilder> implements VisitableBuilder<V1alpha1WebhookThrottleConfig,V1alpha1WebhookThrottleConfigBuilder>{

    V1alpha1WebhookThrottleConfigFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1WebhookThrottleConfigBuilder(){
            this(true);
    }
    public V1alpha1WebhookThrottleConfigBuilder(Boolean validationEnabled){
            this(new V1alpha1WebhookThrottleConfig(), validationEnabled);
    }
    public V1alpha1WebhookThrottleConfigBuilder(V1alpha1WebhookThrottleConfigFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1WebhookThrottleConfigBuilder(V1alpha1WebhookThrottleConfigFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1WebhookThrottleConfig(), validationEnabled);
    }
    public V1alpha1WebhookThrottleConfigBuilder(V1alpha1WebhookThrottleConfigFluent<?> fluent,V1alpha1WebhookThrottleConfig instance){
            this(fluent, instance, true);
    }
    public V1alpha1WebhookThrottleConfigBuilder(V1alpha1WebhookThrottleConfigFluent<?> fluent,V1alpha1WebhookThrottleConfig instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withBurst(instance.getBurst());

            fluent.withQps(instance.getQps());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1WebhookThrottleConfigBuilder(V1alpha1WebhookThrottleConfig instance){
            this(instance,true);
    }
    public V1alpha1WebhookThrottleConfigBuilder(V1alpha1WebhookThrottleConfig instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withBurst(instance.getBurst());

            this.withQps(instance.getQps());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1WebhookThrottleConfig build(){
            V1alpha1WebhookThrottleConfig buildable = new V1alpha1WebhookThrottleConfig();
            buildable.setBurst(fluent.getBurst());
            buildable.setQps(fluent.getQps());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1WebhookThrottleConfigBuilder that = (V1alpha1WebhookThrottleConfigBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
