package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta1APIServiceSpecBuilder extends V1beta1APIServiceSpecFluentImpl<V1beta1APIServiceSpecBuilder> implements VisitableBuilder<V1beta1APIServiceSpec,V1beta1APIServiceSpecBuilder>{

    V1beta1APIServiceSpecFluent<?> fluent;
    Boolean validationEnabled;

    public V1beta1APIServiceSpecBuilder(){
            this(true);
    }
    public V1beta1APIServiceSpecBuilder(Boolean validationEnabled){
            this(new V1beta1APIServiceSpec(), validationEnabled);
    }
    public V1beta1APIServiceSpecBuilder(V1beta1APIServiceSpecFluent<?> fluent){
            this(fluent, true);
    }
    public V1beta1APIServiceSpecBuilder(V1beta1APIServiceSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1beta1APIServiceSpec(), validationEnabled);
    }
    public V1beta1APIServiceSpecBuilder(V1beta1APIServiceSpecFluent<?> fluent,V1beta1APIServiceSpec instance){
            this(fluent, instance, true);
    }
    public V1beta1APIServiceSpecBuilder(V1beta1APIServiceSpecFluent<?> fluent,V1beta1APIServiceSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withCaBundle(instance.getCaBundle());

            fluent.withGroup(instance.getGroup());

            fluent.withGroupPriorityMinimum(instance.getGroupPriorityMinimum());

            fluent.withInsecureSkipTLSVerify(instance.isInsecureSkipTLSVerify());

            fluent.withService(instance.getService());

            fluent.withVersion(instance.getVersion());

            fluent.withVersionPriority(instance.getVersionPriority());

            this.validationEnabled = validationEnabled; 
    }
    public V1beta1APIServiceSpecBuilder(V1beta1APIServiceSpec instance){
            this(instance,true);
    }
    public V1beta1APIServiceSpecBuilder(V1beta1APIServiceSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withCaBundle(instance.getCaBundle());

            this.withGroup(instance.getGroup());

            this.withGroupPriorityMinimum(instance.getGroupPriorityMinimum());

            this.withInsecureSkipTLSVerify(instance.isInsecureSkipTLSVerify());

            this.withService(instance.getService());

            this.withVersion(instance.getVersion());

            this.withVersionPriority(instance.getVersionPriority());

            this.validationEnabled = validationEnabled; 
    }

    public V1beta1APIServiceSpec build(){
            V1beta1APIServiceSpec buildable = new V1beta1APIServiceSpec();
            buildable.setCaBundle(fluent.getCaBundle());
            buildable.setGroup(fluent.getGroup());
            buildable.setGroupPriorityMinimum(fluent.getGroupPriorityMinimum());
            buildable.setInsecureSkipTLSVerify(fluent.isInsecureSkipTLSVerify());
            buildable.setService(fluent.getService());
            buildable.setVersion(fluent.getVersion());
            buildable.setVersionPriority(fluent.getVersionPriority());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1beta1APIServiceSpecBuilder that = (V1beta1APIServiceSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
