package io.kubernetes.client.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Fluent;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface V1beta1EventListFluent<A extends V1beta1EventListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,V1beta1Event item);
    public A setToItems(int index,V1beta1Event item);
    public A addToItems(V1beta1Event... items);
    public A addAllToItems(Collection<V1beta1Event> items);
    public A removeFromItems(V1beta1Event... items);
    public A removeAllFromItems(Collection<V1beta1Event> items);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<V1beta1Event> getItems();
    public List<V1beta1Event> buildItems();
    public V1beta1Event buildItem(int index);
    public V1beta1Event buildFirstItem();
    public V1beta1Event buildLastItem();
    public V1beta1Event buildMatchingItem(io.kubernetes.client.fluent.Predicate<V1beta1EventBuilder> predicate);
    public Boolean hasMatchingItem(io.kubernetes.client.fluent.Predicate<V1beta1EventBuilder> predicate);
    public A withItems(List<V1beta1Event> items);
    public A withItems(V1beta1Event... items);
    public Boolean hasItems();
    public V1beta1EventListFluent.ItemsNested<A> addNewItem();
    public V1beta1EventListFluent.ItemsNested<A> addNewItemLike(V1beta1Event item);
    public V1beta1EventListFluent.ItemsNested<A> setNewItemLike(int index,V1beta1Event item);
    public V1beta1EventListFluent.ItemsNested<A> editItem(int index);
    public V1beta1EventListFluent.ItemsNested<A> editFirstItem();
    public V1beta1EventListFluent.ItemsNested<A> editLastItem();
    public V1beta1EventListFluent.ItemsNested<A> editMatchingItem(io.kubernetes.client.fluent.Predicate<V1beta1EventBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public V1ListMeta getMetadata();
    public V1ListMeta buildMetadata();
    public A withMetadata(V1ListMeta metadata);
    public Boolean hasMetadata();
    public V1beta1EventListFluent.MetadataNested<A> withNewMetadata();
    public V1beta1EventListFluent.MetadataNested<A> withNewMetadataLike(V1ListMeta item);
    public V1beta1EventListFluent.MetadataNested<A> editMetadata();
    public V1beta1EventListFluent.MetadataNested<A> editOrNewMetadata();
    public V1beta1EventListFluent.MetadataNested<A> editOrNewMetadataLike(V1ListMeta item);

    public interface ItemsNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1beta1EventFluent<V1beta1EventListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}
    public interface MetadataNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1ListMetaFluent<V1beta1EventListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
