package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta1HTTPIngressPathBuilder extends V1beta1HTTPIngressPathFluentImpl<V1beta1HTTPIngressPathBuilder> implements VisitableBuilder<V1beta1HTTPIngressPath,V1beta1HTTPIngressPathBuilder>{

    V1beta1HTTPIngressPathFluent<?> fluent;
    Boolean validationEnabled;

    public V1beta1HTTPIngressPathBuilder(){
            this(true);
    }
    public V1beta1HTTPIngressPathBuilder(Boolean validationEnabled){
            this(new V1beta1HTTPIngressPath(), validationEnabled);
    }
    public V1beta1HTTPIngressPathBuilder(V1beta1HTTPIngressPathFluent<?> fluent){
            this(fluent, true);
    }
    public V1beta1HTTPIngressPathBuilder(V1beta1HTTPIngressPathFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1beta1HTTPIngressPath(), validationEnabled);
    }
    public V1beta1HTTPIngressPathBuilder(V1beta1HTTPIngressPathFluent<?> fluent,V1beta1HTTPIngressPath instance){
            this(fluent, instance, true);
    }
    public V1beta1HTTPIngressPathBuilder(V1beta1HTTPIngressPathFluent<?> fluent,V1beta1HTTPIngressPath instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withBackend(instance.getBackend());

            fluent.withPath(instance.getPath());

            this.validationEnabled = validationEnabled; 
    }
    public V1beta1HTTPIngressPathBuilder(V1beta1HTTPIngressPath instance){
            this(instance,true);
    }
    public V1beta1HTTPIngressPathBuilder(V1beta1HTTPIngressPath instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withBackend(instance.getBackend());

            this.withPath(instance.getPath());

            this.validationEnabled = validationEnabled; 
    }

    public V1beta1HTTPIngressPath build(){
            V1beta1HTTPIngressPath buildable = new V1beta1HTTPIngressPath();
            buildable.setBackend(fluent.getBackend());
            buildable.setPath(fluent.getPath());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1beta1HTTPIngressPathBuilder that = (V1beta1HTTPIngressPathBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
