package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta1IngressBackendBuilder extends V1beta1IngressBackendFluentImpl<V1beta1IngressBackendBuilder> implements VisitableBuilder<V1beta1IngressBackend,V1beta1IngressBackendBuilder>{

    V1beta1IngressBackendFluent<?> fluent;
    Boolean validationEnabled;

    public V1beta1IngressBackendBuilder(){
            this(true);
    }
    public V1beta1IngressBackendBuilder(Boolean validationEnabled){
            this(new V1beta1IngressBackend(), validationEnabled);
    }
    public V1beta1IngressBackendBuilder(V1beta1IngressBackendFluent<?> fluent){
            this(fluent, true);
    }
    public V1beta1IngressBackendBuilder(V1beta1IngressBackendFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1beta1IngressBackend(), validationEnabled);
    }
    public V1beta1IngressBackendBuilder(V1beta1IngressBackendFluent<?> fluent,V1beta1IngressBackend instance){
            this(fluent, instance, true);
    }
    public V1beta1IngressBackendBuilder(V1beta1IngressBackendFluent<?> fluent,V1beta1IngressBackend instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withServiceName(instance.getServiceName());

            fluent.withServicePort(instance.getServicePort());

            this.validationEnabled = validationEnabled; 
    }
    public V1beta1IngressBackendBuilder(V1beta1IngressBackend instance){
            this(instance,true);
    }
    public V1beta1IngressBackendBuilder(V1beta1IngressBackend instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withServiceName(instance.getServiceName());

            this.withServicePort(instance.getServicePort());

            this.validationEnabled = validationEnabled; 
    }

    public V1beta1IngressBackend build(){
            V1beta1IngressBackend buildable = new V1beta1IngressBackend();
            buildable.setServiceName(fluent.getServiceName());
            buildable.setServicePort(fluent.getServicePort());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1beta1IngressBackendBuilder that = (V1beta1IngressBackendBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
