package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;

public class V1beta1IngressSpecFluentImpl<A extends V1beta1IngressSpecFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1beta1IngressSpecFluent<A>{

    private V1beta1IngressBackendBuilder backend;
    private List<V1beta1IngressRuleBuilder> rules;
    private List<V1beta1IngressTLSBuilder> tls;

    public V1beta1IngressSpecFluentImpl(){
    }
    public V1beta1IngressSpecFluentImpl(V1beta1IngressSpec instance){
            this.withBackend(instance.getBackend());

            this.withRules(instance.getRules());

            this.withTls(instance.getTls());

    }

    
/**
 * This method has been deprecated, please use method buildBackend instead.
 * @return The buildable object.
 */
@Deprecated public V1beta1IngressBackend getBackend(){
            return this.backend!=null?this.backend.build():null;
    }

    public V1beta1IngressBackend buildBackend(){
            return this.backend!=null?this.backend.build():null;
    }

    public A withBackend(V1beta1IngressBackend backend){
            _visitables.get("backend").remove(this.backend);
            if (backend!=null){ this.backend= new V1beta1IngressBackendBuilder(backend); _visitables.get("backend").add(this.backend);} return (A) this;
    }

    public Boolean hasBackend(){
            return this.backend != null;
    }

    public V1beta1IngressSpecFluent.BackendNested<A> withNewBackend(){
            return new BackendNestedImpl();
    }

    public V1beta1IngressSpecFluent.BackendNested<A> withNewBackendLike(V1beta1IngressBackend item){
            return new BackendNestedImpl(item);
    }

    public V1beta1IngressSpecFluent.BackendNested<A> editBackend(){
            return withNewBackendLike(getBackend());
    }

    public V1beta1IngressSpecFluent.BackendNested<A> editOrNewBackend(){
            return withNewBackendLike(getBackend() != null ? getBackend(): new V1beta1IngressBackendBuilder().build());
    }

    public V1beta1IngressSpecFluent.BackendNested<A> editOrNewBackendLike(V1beta1IngressBackend item){
            return withNewBackendLike(getBackend() != null ? getBackend(): item);
    }

    public A addToRules(int index,V1beta1IngressRule item){
            if (this.rules == null) {this.rules = new ArrayList<V1beta1IngressRuleBuilder>();}
            V1beta1IngressRuleBuilder builder = new V1beta1IngressRuleBuilder(item);_visitables.get("rules").add(index >= 0 ? index : _visitables.get("rules").size(), builder);this.rules.add(index >= 0 ? index : rules.size(), builder); return (A)this;
    }

    public A setToRules(int index,V1beta1IngressRule item){
            if (this.rules == null) {this.rules = new ArrayList<V1beta1IngressRuleBuilder>();}
            V1beta1IngressRuleBuilder builder = new V1beta1IngressRuleBuilder(item);
            if (index < 0 || index >= _visitables.get("rules").size()) { _visitables.get("rules").add(builder); } else { _visitables.get("rules").set(index, builder);}
            if (index < 0 || index >= rules.size()) { rules.add(builder); } else { rules.set(index, builder);}
             return (A)this;
    }

    public A addToRules(V1beta1IngressRule... items){
            if (this.rules == null) {this.rules = new ArrayList<V1beta1IngressRuleBuilder>();}
            for (V1beta1IngressRule item : items) {V1beta1IngressRuleBuilder builder = new V1beta1IngressRuleBuilder(item);_visitables.get("rules").add(builder);this.rules.add(builder);} return (A)this;
    }

    public A addAllToRules(Collection<V1beta1IngressRule> items){
            if (this.rules == null) {this.rules = new ArrayList<V1beta1IngressRuleBuilder>();}
            for (V1beta1IngressRule item : items) {V1beta1IngressRuleBuilder builder = new V1beta1IngressRuleBuilder(item);_visitables.get("rules").add(builder);this.rules.add(builder);} return (A)this;
    }

    public A removeFromRules(V1beta1IngressRule... items){
            for (V1beta1IngressRule item : items) {V1beta1IngressRuleBuilder builder = new V1beta1IngressRuleBuilder(item);_visitables.get("rules").remove(builder);if (this.rules != null) {this.rules.remove(builder);}} return (A)this;
    }

    public A removeAllFromRules(Collection<V1beta1IngressRule> items){
            for (V1beta1IngressRule item : items) {V1beta1IngressRuleBuilder builder = new V1beta1IngressRuleBuilder(item);_visitables.get("rules").remove(builder);if (this.rules != null) {this.rules.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildRules instead.
 * @return The buildable object.
 */
@Deprecated public List<V1beta1IngressRule> getRules(){
            return build(rules);
    }

    public List<V1beta1IngressRule> buildRules(){
            return build(rules);
    }

    public V1beta1IngressRule buildRule(int index){
            return this.rules.get(index).build();
    }

    public V1beta1IngressRule buildFirstRule(){
            return this.rules.get(0).build();
    }

    public V1beta1IngressRule buildLastRule(){
            return this.rules.get(rules.size() - 1).build();
    }

    public V1beta1IngressRule buildMatchingRule(io.kubernetes.client.fluent.Predicate<V1beta1IngressRuleBuilder> predicate){
            for (V1beta1IngressRuleBuilder item: rules) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingRule(io.kubernetes.client.fluent.Predicate<V1beta1IngressRuleBuilder> predicate){
            for (V1beta1IngressRuleBuilder item: rules) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withRules(List<V1beta1IngressRule> rules){
            if (this.rules != null) { _visitables.get("rules").removeAll(this.rules);}
            if (rules != null) {this.rules = new ArrayList<V1beta1IngressRuleBuilder>(); for (V1beta1IngressRule item : rules){this.addToRules(item);}} else { this.rules = null;} return (A) this;
    }

    public A withRules(V1beta1IngressRule... rules){
            if (this.rules != null) {this.rules.clear();}
            if (rules != null) {for (V1beta1IngressRule item :rules){ this.addToRules(item);}} return (A) this;
    }

    public Boolean hasRules(){
            return rules != null && !rules.isEmpty();
    }

    public V1beta1IngressSpecFluent.RulesNested<A> addNewRule(){
            return new RulesNestedImpl();
    }

    public V1beta1IngressSpecFluent.RulesNested<A> addNewRuleLike(V1beta1IngressRule item){
            return new RulesNestedImpl(-1, item);
    }

    public V1beta1IngressSpecFluent.RulesNested<A> setNewRuleLike(int index,V1beta1IngressRule item){
            return new RulesNestedImpl(index, item);
    }

    public V1beta1IngressSpecFluent.RulesNested<A> editRule(int index){
            if (rules.size() <= index) throw new RuntimeException("Can't edit rules. Index exceeds size.");
            return setNewRuleLike(index, buildRule(index));
    }

    public V1beta1IngressSpecFluent.RulesNested<A> editFirstRule(){
            if (rules.size() == 0) throw new RuntimeException("Can't edit first rules. The list is empty.");
            return setNewRuleLike(0, buildRule(0));
    }

    public V1beta1IngressSpecFluent.RulesNested<A> editLastRule(){
            int index = rules.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last rules. The list is empty.");
            return setNewRuleLike(index, buildRule(index));
    }

    public V1beta1IngressSpecFluent.RulesNested<A> editMatchingRule(io.kubernetes.client.fluent.Predicate<V1beta1IngressRuleBuilder> predicate){
            int index = -1;
            for (int i=0;i<rules.size();i++) { 
            if (predicate.apply(rules.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching rules. No match found.");
            return setNewRuleLike(index, buildRule(index));
    }

    public A addToTls(int index,V1beta1IngressTLS item){
            if (this.tls == null) {this.tls = new ArrayList<V1beta1IngressTLSBuilder>();}
            V1beta1IngressTLSBuilder builder = new V1beta1IngressTLSBuilder(item);_visitables.get("tls").add(index >= 0 ? index : _visitables.get("tls").size(), builder);this.tls.add(index >= 0 ? index : tls.size(), builder); return (A)this;
    }

    public A setToTls(int index,V1beta1IngressTLS item){
            if (this.tls == null) {this.tls = new ArrayList<V1beta1IngressTLSBuilder>();}
            V1beta1IngressTLSBuilder builder = new V1beta1IngressTLSBuilder(item);
            if (index < 0 || index >= _visitables.get("tls").size()) { _visitables.get("tls").add(builder); } else { _visitables.get("tls").set(index, builder);}
            if (index < 0 || index >= tls.size()) { tls.add(builder); } else { tls.set(index, builder);}
             return (A)this;
    }

    public A addToTls(V1beta1IngressTLS... items){
            if (this.tls == null) {this.tls = new ArrayList<V1beta1IngressTLSBuilder>();}
            for (V1beta1IngressTLS item : items) {V1beta1IngressTLSBuilder builder = new V1beta1IngressTLSBuilder(item);_visitables.get("tls").add(builder);this.tls.add(builder);} return (A)this;
    }

    public A addAllToTls(Collection<V1beta1IngressTLS> items){
            if (this.tls == null) {this.tls = new ArrayList<V1beta1IngressTLSBuilder>();}
            for (V1beta1IngressTLS item : items) {V1beta1IngressTLSBuilder builder = new V1beta1IngressTLSBuilder(item);_visitables.get("tls").add(builder);this.tls.add(builder);} return (A)this;
    }

    public A removeFromTls(V1beta1IngressTLS... items){
            for (V1beta1IngressTLS item : items) {V1beta1IngressTLSBuilder builder = new V1beta1IngressTLSBuilder(item);_visitables.get("tls").remove(builder);if (this.tls != null) {this.tls.remove(builder);}} return (A)this;
    }

    public A removeAllFromTls(Collection<V1beta1IngressTLS> items){
            for (V1beta1IngressTLS item : items) {V1beta1IngressTLSBuilder builder = new V1beta1IngressTLSBuilder(item);_visitables.get("tls").remove(builder);if (this.tls != null) {this.tls.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildTls instead.
 * @return The buildable object.
 */
@Deprecated public List<V1beta1IngressTLS> getTls(){
            return build(tls);
    }

    public List<V1beta1IngressTLS> buildTls(){
            return build(tls);
    }

    public V1beta1IngressTLS buildTl(int index){
            return this.tls.get(index).build();
    }

    public V1beta1IngressTLS buildFirstTl(){
            return this.tls.get(0).build();
    }

    public V1beta1IngressTLS buildLastTl(){
            return this.tls.get(tls.size() - 1).build();
    }

    public V1beta1IngressTLS buildMatchingTl(io.kubernetes.client.fluent.Predicate<V1beta1IngressTLSBuilder> predicate){
            for (V1beta1IngressTLSBuilder item: tls) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingTl(io.kubernetes.client.fluent.Predicate<V1beta1IngressTLSBuilder> predicate){
            for (V1beta1IngressTLSBuilder item: tls) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withTls(List<V1beta1IngressTLS> tls){
            if (this.tls != null) { _visitables.get("tls").removeAll(this.tls);}
            if (tls != null) {this.tls = new ArrayList<V1beta1IngressTLSBuilder>(); for (V1beta1IngressTLS item : tls){this.addToTls(item);}} else { this.tls = null;} return (A) this;
    }

    public A withTls(V1beta1IngressTLS... tls){
            if (this.tls != null) {this.tls.clear();}
            if (tls != null) {for (V1beta1IngressTLS item :tls){ this.addToTls(item);}} return (A) this;
    }

    public Boolean hasTls(){
            return tls != null && !tls.isEmpty();
    }

    public V1beta1IngressSpecFluent.TlsNested<A> addNewTl(){
            return new TlsNestedImpl();
    }

    public V1beta1IngressSpecFluent.TlsNested<A> addNewTlLike(V1beta1IngressTLS item){
            return new TlsNestedImpl(-1, item);
    }

    public V1beta1IngressSpecFluent.TlsNested<A> setNewTlLike(int index,V1beta1IngressTLS item){
            return new TlsNestedImpl(index, item);
    }

    public V1beta1IngressSpecFluent.TlsNested<A> editTl(int index){
            if (tls.size() <= index) throw new RuntimeException("Can't edit tls. Index exceeds size.");
            return setNewTlLike(index, buildTl(index));
    }

    public V1beta1IngressSpecFluent.TlsNested<A> editFirstTl(){
            if (tls.size() == 0) throw new RuntimeException("Can't edit first tls. The list is empty.");
            return setNewTlLike(0, buildTl(0));
    }

    public V1beta1IngressSpecFluent.TlsNested<A> editLastTl(){
            int index = tls.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last tls. The list is empty.");
            return setNewTlLike(index, buildTl(index));
    }

    public V1beta1IngressSpecFluent.TlsNested<A> editMatchingTl(io.kubernetes.client.fluent.Predicate<V1beta1IngressTLSBuilder> predicate){
            int index = -1;
            for (int i=0;i<tls.size();i++) { 
            if (predicate.apply(tls.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching tls. No match found.");
            return setNewTlLike(index, buildTl(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1beta1IngressSpecFluentImpl that = (V1beta1IngressSpecFluentImpl) o;
            if (backend != null ? !backend.equals(that.backend) :that.backend != null) return false;
            if (rules != null ? !rules.equals(that.rules) :that.rules != null) return false;
            if (tls != null ? !tls.equals(that.tls) :that.tls != null) return false;
            return true;
    }


    public class BackendNestedImpl<N> extends V1beta1IngressBackendFluentImpl<V1beta1IngressSpecFluent.BackendNested<N>> implements V1beta1IngressSpecFluent.BackendNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1beta1IngressBackendBuilder builder;
    
            BackendNestedImpl(V1beta1IngressBackend item){
                    this.builder = new V1beta1IngressBackendBuilder(this, item);
            }
            BackendNestedImpl(){
                    this.builder = new V1beta1IngressBackendBuilder(this);
            }
    
    public N and(){
            return (N) V1beta1IngressSpecFluentImpl.this.withBackend(builder.build());
    }
    public N endBackend(){
            return and();
    }

}
    public class RulesNestedImpl<N> extends V1beta1IngressRuleFluentImpl<V1beta1IngressSpecFluent.RulesNested<N>> implements V1beta1IngressSpecFluent.RulesNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1beta1IngressRuleBuilder builder;
        private final int index;
    
            RulesNestedImpl(int index,V1beta1IngressRule item){
                    this.index = index;
                    this.builder = new V1beta1IngressRuleBuilder(this, item);
            }
            RulesNestedImpl(){
                    this.index = -1;
                    this.builder = new V1beta1IngressRuleBuilder(this);
            }
    
    public N and(){
            return (N) V1beta1IngressSpecFluentImpl.this.setToRules(index, builder.build());
    }
    public N endRule(){
            return and();
    }

}
    public class TlsNestedImpl<N> extends V1beta1IngressTLSFluentImpl<V1beta1IngressSpecFluent.TlsNested<N>> implements V1beta1IngressSpecFluent.TlsNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1beta1IngressTLSBuilder builder;
        private final int index;
    
            TlsNestedImpl(int index,V1beta1IngressTLS item){
                    this.index = index;
                    this.builder = new V1beta1IngressTLSBuilder(this, item);
            }
            TlsNestedImpl(){
                    this.index = -1;
                    this.builder = new V1beta1IngressTLSBuilder(this);
            }
    
    public N and(){
            return (N) V1beta1IngressSpecFluentImpl.this.setToTls(index, builder.build());
    }
    public N endTl(){
            return and();
    }

}


}
