package io.kubernetes.client.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;

public class V1beta1NetworkPolicyListFluentImpl<A extends V1beta1NetworkPolicyListFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1beta1NetworkPolicyListFluent<A>{

    private String apiVersion;
    private List<V1beta1NetworkPolicyBuilder> items;
    private String kind;
    private V1ListMetaBuilder metadata;

    public V1beta1NetworkPolicyListFluentImpl(){
    }
    public V1beta1NetworkPolicyListFluentImpl(V1beta1NetworkPolicyList instance){
            this.withApiVersion(instance.getApiVersion());

            this.withItems(instance.getItems());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A addToItems(int index,V1beta1NetworkPolicy item){
            if (this.items == null) {this.items = new ArrayList<V1beta1NetworkPolicyBuilder>();}
            V1beta1NetworkPolicyBuilder builder = new V1beta1NetworkPolicyBuilder(item);_visitables.get("items").add(index >= 0 ? index : _visitables.get("items").size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToItems(int index,V1beta1NetworkPolicy item){
            if (this.items == null) {this.items = new ArrayList<V1beta1NetworkPolicyBuilder>();}
            V1beta1NetworkPolicyBuilder builder = new V1beta1NetworkPolicyBuilder(item);
            if (index < 0 || index >= _visitables.get("items").size()) { _visitables.get("items").add(builder); } else { _visitables.get("items").set(index, builder);}
            if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
             return (A)this;
    }

    public A addToItems(V1beta1NetworkPolicy... items){
            if (this.items == null) {this.items = new ArrayList<V1beta1NetworkPolicyBuilder>();}
            for (V1beta1NetworkPolicy item : items) {V1beta1NetworkPolicyBuilder builder = new V1beta1NetworkPolicyBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToItems(Collection<V1beta1NetworkPolicy> items){
            if (this.items == null) {this.items = new ArrayList<V1beta1NetworkPolicyBuilder>();}
            for (V1beta1NetworkPolicy item : items) {V1beta1NetworkPolicyBuilder builder = new V1beta1NetworkPolicyBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromItems(V1beta1NetworkPolicy... items){
            for (V1beta1NetworkPolicy item : items) {V1beta1NetworkPolicyBuilder builder = new V1beta1NetworkPolicyBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    public A removeAllFromItems(Collection<V1beta1NetworkPolicy> items){
            for (V1beta1NetworkPolicy item : items) {V1beta1NetworkPolicyBuilder builder = new V1beta1NetworkPolicyBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<V1beta1NetworkPolicy> getItems(){
            return build(items);
    }

    public List<V1beta1NetworkPolicy> buildItems(){
            return build(items);
    }

    public V1beta1NetworkPolicy buildItem(int index){
            return this.items.get(index).build();
    }

    public V1beta1NetworkPolicy buildFirstItem(){
            return this.items.get(0).build();
    }

    public V1beta1NetworkPolicy buildLastItem(){
            return this.items.get(items.size() - 1).build();
    }

    public V1beta1NetworkPolicy buildMatchingItem(io.kubernetes.client.fluent.Predicate<V1beta1NetworkPolicyBuilder> predicate){
            for (V1beta1NetworkPolicyBuilder item: items) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingItem(io.kubernetes.client.fluent.Predicate<V1beta1NetworkPolicyBuilder> predicate){
            for (V1beta1NetworkPolicyBuilder item: items) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withItems(List<V1beta1NetworkPolicy> items){
            if (this.items != null) { _visitables.get("items").removeAll(this.items);}
            if (items != null) {this.items = new ArrayList<V1beta1NetworkPolicyBuilder>(); for (V1beta1NetworkPolicy item : items){this.addToItems(item);}} else { this.items = null;} return (A) this;
    }

    public A withItems(V1beta1NetworkPolicy... items){
            if (this.items != null) {this.items.clear();}
            if (items != null) {for (V1beta1NetworkPolicy item :items){ this.addToItems(item);}} return (A) this;
    }

    public Boolean hasItems(){
            return items != null && !items.isEmpty();
    }

    public V1beta1NetworkPolicyListFluent.ItemsNested<A> addNewItem(){
            return new ItemsNestedImpl();
    }

    public V1beta1NetworkPolicyListFluent.ItemsNested<A> addNewItemLike(V1beta1NetworkPolicy item){
            return new ItemsNestedImpl(-1, item);
    }

    public V1beta1NetworkPolicyListFluent.ItemsNested<A> setNewItemLike(int index,V1beta1NetworkPolicy item){
            return new ItemsNestedImpl(index, item);
    }

    public V1beta1NetworkPolicyListFluent.ItemsNested<A> editItem(int index){
            if (items.size() <= index) throw new RuntimeException("Can't edit items. Index exceeds size.");
            return setNewItemLike(index, buildItem(index));
    }

    public V1beta1NetworkPolicyListFluent.ItemsNested<A> editFirstItem(){
            if (items.size() == 0) throw new RuntimeException("Can't edit first items. The list is empty.");
            return setNewItemLike(0, buildItem(0));
    }

    public V1beta1NetworkPolicyListFluent.ItemsNested<A> editLastItem(){
            int index = items.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last items. The list is empty.");
            return setNewItemLike(index, buildItem(index));
    }

    public V1beta1NetworkPolicyListFluent.ItemsNested<A> editMatchingItem(io.kubernetes.client.fluent.Predicate<V1beta1NetworkPolicyBuilder> predicate){
            int index = -1;
            for (int i=0;i<items.size();i++) { 
            if (predicate.apply(items.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching items. No match found.");
            return setNewItemLike(index, buildItem(index));
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    public A withNewKind(String arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1){
            return (A)withKind(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public V1ListMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public V1ListMeta buildMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(V1ListMeta metadata){
            _visitables.get("metadata").remove(this.metadata);
            if (metadata!=null){ this.metadata= new V1ListMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata(){
            return this.metadata != null;
    }

    public V1beta1NetworkPolicyListFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public V1beta1NetworkPolicyListFluent.MetadataNested<A> withNewMetadataLike(V1ListMeta item){
            return new MetadataNestedImpl(item);
    }

    public V1beta1NetworkPolicyListFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public V1beta1NetworkPolicyListFluent.MetadataNested<A> editOrNewMetadata(){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): new V1ListMetaBuilder().build());
    }

    public V1beta1NetworkPolicyListFluent.MetadataNested<A> editOrNewMetadataLike(V1ListMeta item){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1beta1NetworkPolicyListFluentImpl that = (V1beta1NetworkPolicyListFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (items != null ? !items.equals(that.items) :that.items != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            return true;
    }


    public class ItemsNestedImpl<N> extends V1beta1NetworkPolicyFluentImpl<V1beta1NetworkPolicyListFluent.ItemsNested<N>> implements V1beta1NetworkPolicyListFluent.ItemsNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1beta1NetworkPolicyBuilder builder;
        private final int index;
    
            ItemsNestedImpl(int index,V1beta1NetworkPolicy item){
                    this.index = index;
                    this.builder = new V1beta1NetworkPolicyBuilder(this, item);
            }
            ItemsNestedImpl(){
                    this.index = -1;
                    this.builder = new V1beta1NetworkPolicyBuilder(this);
            }
    
    public N and(){
            return (N) V1beta1NetworkPolicyListFluentImpl.this.setToItems(index, builder.build());
    }
    public N endItem(){
            return and();
    }

}
    public class MetadataNestedImpl<N> extends V1ListMetaFluentImpl<V1beta1NetworkPolicyListFluent.MetadataNested<N>> implements V1beta1NetworkPolicyListFluent.MetadataNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1ListMetaBuilder builder;
    
            MetadataNestedImpl(V1ListMeta item){
                    this.builder = new V1ListMetaBuilder(this, item);
            }
            MetadataNestedImpl(){
                    this.builder = new V1ListMetaBuilder(this);
            }
    
    public N and(){
            return (N) V1beta1NetworkPolicyListFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}


}
