package io.kubernetes.client.models;

import io.kubernetes.client.custom.IntOrString;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta1PodDisruptionBudgetSpecFluentImpl<A extends V1beta1PodDisruptionBudgetSpecFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1beta1PodDisruptionBudgetSpecFluent<A>{

    private IntOrString maxUnavailable;
    private IntOrString minAvailable;
    private V1LabelSelectorBuilder selector;

    public V1beta1PodDisruptionBudgetSpecFluentImpl(){
    }
    public V1beta1PodDisruptionBudgetSpecFluentImpl(V1beta1PodDisruptionBudgetSpec instance){
            this.withMaxUnavailable(instance.getMaxUnavailable());

            this.withMinAvailable(instance.getMinAvailable());

            this.withSelector(instance.getSelector());

    }

    public IntOrString getMaxUnavailable(){
            return this.maxUnavailable;
    }

    public A withMaxUnavailable(IntOrString maxUnavailable){
            this.maxUnavailable=maxUnavailable; return (A) this;
    }

    public Boolean hasMaxUnavailable(){
            return this.maxUnavailable != null;
    }

    public A withNewMaxUnavailable(final int value){
            return (A)withMaxUnavailable(new IntOrString(value));
    }

    public A withNewMaxUnavailable(final String value){
            return (A)withMaxUnavailable(new IntOrString(value));
    }

    public IntOrString getMinAvailable(){
            return this.minAvailable;
    }

    public A withMinAvailable(IntOrString minAvailable){
            this.minAvailable=minAvailable; return (A) this;
    }

    public Boolean hasMinAvailable(){
            return this.minAvailable != null;
    }

    public A withNewMinAvailable(final int value){
            return (A)withMinAvailable(new IntOrString(value));
    }

    public A withNewMinAvailable(final String value){
            return (A)withMinAvailable(new IntOrString(value));
    }

    
/**
 * This method has been deprecated, please use method buildSelector instead.
 * @return The buildable object.
 */
@Deprecated public V1LabelSelector getSelector(){
            return this.selector!=null?this.selector.build():null;
    }

    public V1LabelSelector buildSelector(){
            return this.selector!=null?this.selector.build():null;
    }

    public A withSelector(V1LabelSelector selector){
            _visitables.get("selector").remove(this.selector);
            if (selector!=null){ this.selector= new V1LabelSelectorBuilder(selector); _visitables.get("selector").add(this.selector);} return (A) this;
    }

    public Boolean hasSelector(){
            return this.selector != null;
    }

    public V1beta1PodDisruptionBudgetSpecFluent.SelectorNested<A> withNewSelector(){
            return new SelectorNestedImpl();
    }

    public V1beta1PodDisruptionBudgetSpecFluent.SelectorNested<A> withNewSelectorLike(V1LabelSelector item){
            return new SelectorNestedImpl(item);
    }

    public V1beta1PodDisruptionBudgetSpecFluent.SelectorNested<A> editSelector(){
            return withNewSelectorLike(getSelector());
    }

    public V1beta1PodDisruptionBudgetSpecFluent.SelectorNested<A> editOrNewSelector(){
            return withNewSelectorLike(getSelector() != null ? getSelector(): new V1LabelSelectorBuilder().build());
    }

    public V1beta1PodDisruptionBudgetSpecFluent.SelectorNested<A> editOrNewSelectorLike(V1LabelSelector item){
            return withNewSelectorLike(getSelector() != null ? getSelector(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1beta1PodDisruptionBudgetSpecFluentImpl that = (V1beta1PodDisruptionBudgetSpecFluentImpl) o;
            if (maxUnavailable != null ? !maxUnavailable.equals(that.maxUnavailable) :that.maxUnavailable != null) return false;
            if (minAvailable != null ? !minAvailable.equals(that.minAvailable) :that.minAvailable != null) return false;
            if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
            return true;
    }


    public class SelectorNestedImpl<N> extends V1LabelSelectorFluentImpl<V1beta1PodDisruptionBudgetSpecFluent.SelectorNested<N>> implements V1beta1PodDisruptionBudgetSpecFluent.SelectorNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1LabelSelectorBuilder builder;
    
            SelectorNestedImpl(V1LabelSelector item){
                    this.builder = new V1LabelSelectorBuilder(this, item);
            }
            SelectorNestedImpl(){
                    this.builder = new V1LabelSelectorBuilder(this);
            }
    
    public N and(){
            return (N) V1beta1PodDisruptionBudgetSpecFluentImpl.this.withSelector(builder.build());
    }
    public N endSelector(){
            return and();
    }

}


}
