package io.kubernetes.client.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.lang.String;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta1PriorityClassFluentImpl<A extends V1beta1PriorityClassFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1beta1PriorityClassFluent<A>{

    private String apiVersion;
    private String description;
    private Boolean globalDefault;
    private String kind;
    private V1ObjectMetaBuilder metadata;
    private Integer value;

    public V1beta1PriorityClassFluentImpl(){
    }
    public V1beta1PriorityClassFluentImpl(V1beta1PriorityClass instance){
            this.withApiVersion(instance.getApiVersion());

            this.withDescription(instance.getDescription());

            this.withGlobalDefault(instance.isGlobalDefault());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.withValue(instance.getValue());

    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public String getDescription(){
            return this.description;
    }

    public A withDescription(String description){
            this.description=description; return (A) this;
    }

    public Boolean hasDescription(){
            return this.description != null;
    }

    public A withNewDescription(String arg1){
            return (A)withDescription(new String(arg1));
    }

    public A withNewDescription(StringBuilder arg1){
            return (A)withDescription(new String(arg1));
    }

    public A withNewDescription(StringBuffer arg1){
            return (A)withDescription(new String(arg1));
    }

    public Boolean isGlobalDefault(){
            return this.globalDefault;
    }

    public A withGlobalDefault(Boolean globalDefault){
            this.globalDefault=globalDefault; return (A) this;
    }

    public Boolean hasGlobalDefault(){
            return this.globalDefault != null;
    }

    public A withNewGlobalDefault(String arg1){
            return (A)withGlobalDefault(new Boolean(arg1));
    }

    public A withNewGlobalDefault(boolean arg1){
            return (A)withGlobalDefault(new Boolean(arg1));
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    public A withNewKind(String arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1){
            return (A)withKind(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public V1ObjectMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public V1ObjectMeta buildMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(V1ObjectMeta metadata){
            _visitables.get("metadata").remove(this.metadata);
            if (metadata!=null){ this.metadata= new V1ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata(){
            return this.metadata != null;
    }

    public V1beta1PriorityClassFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public V1beta1PriorityClassFluent.MetadataNested<A> withNewMetadataLike(V1ObjectMeta item){
            return new MetadataNestedImpl(item);
    }

    public V1beta1PriorityClassFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public V1beta1PriorityClassFluent.MetadataNested<A> editOrNewMetadata(){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): new V1ObjectMetaBuilder().build());
    }

    public V1beta1PriorityClassFluent.MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    public Integer getValue(){
            return this.value;
    }

    public A withValue(Integer value){
            this.value=value; return (A) this;
    }

    public Boolean hasValue(){
            return this.value != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1beta1PriorityClassFluentImpl that = (V1beta1PriorityClassFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (description != null ? !description.equals(that.description) :that.description != null) return false;
            if (globalDefault != null ? !globalDefault.equals(that.globalDefault) :that.globalDefault != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            if (value != null ? !value.equals(that.value) :that.value != null) return false;
            return true;
    }


    public class MetadataNestedImpl<N> extends V1ObjectMetaFluentImpl<V1beta1PriorityClassFluent.MetadataNested<N>> implements V1beta1PriorityClassFluent.MetadataNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1ObjectMetaBuilder builder;
    
            MetadataNestedImpl(V1ObjectMeta item){
                    this.builder = new V1ObjectMetaBuilder(this, item);
            }
            MetadataNestedImpl(){
                    this.builder = new V1ObjectMetaBuilder(this);
            }
    
    public N and(){
            return (N) V1beta1PriorityClassFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}


}
