package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Fluent;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface V1beta2DaemonSetStatusFluent<A extends V1beta2DaemonSetStatusFluent<A>> extends Fluent<A>{


    public Integer getCollisionCount();
    public A withCollisionCount(Integer collisionCount);
    public Boolean hasCollisionCount();
    public A addToConditions(int index,V1beta2DaemonSetCondition item);
    public A setToConditions(int index,V1beta2DaemonSetCondition item);
    public A addToConditions(V1beta2DaemonSetCondition... items);
    public A addAllToConditions(Collection<V1beta2DaemonSetCondition> items);
    public A removeFromConditions(V1beta2DaemonSetCondition... items);
    public A removeAllFromConditions(Collection<V1beta2DaemonSetCondition> items);
    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<V1beta2DaemonSetCondition> getConditions();
    public List<V1beta2DaemonSetCondition> buildConditions();
    public V1beta2DaemonSetCondition buildCondition(int index);
    public V1beta2DaemonSetCondition buildFirstCondition();
    public V1beta2DaemonSetCondition buildLastCondition();
    public V1beta2DaemonSetCondition buildMatchingCondition(io.kubernetes.client.fluent.Predicate<V1beta2DaemonSetConditionBuilder> predicate);
    public Boolean hasMatchingCondition(io.kubernetes.client.fluent.Predicate<V1beta2DaemonSetConditionBuilder> predicate);
    public A withConditions(List<V1beta2DaemonSetCondition> conditions);
    public A withConditions(V1beta2DaemonSetCondition... conditions);
    public Boolean hasConditions();
    public V1beta2DaemonSetStatusFluent.ConditionsNested<A> addNewCondition();
    public V1beta2DaemonSetStatusFluent.ConditionsNested<A> addNewConditionLike(V1beta2DaemonSetCondition item);
    public V1beta2DaemonSetStatusFluent.ConditionsNested<A> setNewConditionLike(int index,V1beta2DaemonSetCondition item);
    public V1beta2DaemonSetStatusFluent.ConditionsNested<A> editCondition(int index);
    public V1beta2DaemonSetStatusFluent.ConditionsNested<A> editFirstCondition();
    public V1beta2DaemonSetStatusFluent.ConditionsNested<A> editLastCondition();
    public V1beta2DaemonSetStatusFluent.ConditionsNested<A> editMatchingCondition(io.kubernetes.client.fluent.Predicate<V1beta2DaemonSetConditionBuilder> predicate);
    public Integer getCurrentNumberScheduled();
    public A withCurrentNumberScheduled(Integer currentNumberScheduled);
    public Boolean hasCurrentNumberScheduled();
    public Integer getDesiredNumberScheduled();
    public A withDesiredNumberScheduled(Integer desiredNumberScheduled);
    public Boolean hasDesiredNumberScheduled();
    public Integer getNumberAvailable();
    public A withNumberAvailable(Integer numberAvailable);
    public Boolean hasNumberAvailable();
    public Integer getNumberMisscheduled();
    public A withNumberMisscheduled(Integer numberMisscheduled);
    public Boolean hasNumberMisscheduled();
    public Integer getNumberReady();
    public A withNumberReady(Integer numberReady);
    public Boolean hasNumberReady();
    public Integer getNumberUnavailable();
    public A withNumberUnavailable(Integer numberUnavailable);
    public Boolean hasNumberUnavailable();
    public Long getObservedGeneration();
    public A withObservedGeneration(Long observedGeneration);
    public Boolean hasObservedGeneration();
    public Integer getUpdatedNumberScheduled();
    public A withUpdatedNumberScheduled(Integer updatedNumberScheduled);
    public Boolean hasUpdatedNumberScheduled();

    public interface ConditionsNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1beta2DaemonSetConditionFluent<V1beta2DaemonSetStatusFluent.ConditionsNested<N>>{

        
    public N and();    public N endCondition();
}


}
