package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta2DaemonSetUpdateStrategyBuilder extends V1beta2DaemonSetUpdateStrategyFluentImpl<V1beta2DaemonSetUpdateStrategyBuilder> implements VisitableBuilder<V1beta2DaemonSetUpdateStrategy,V1beta2DaemonSetUpdateStrategyBuilder>{

    V1beta2DaemonSetUpdateStrategyFluent<?> fluent;
    Boolean validationEnabled;

    public V1beta2DaemonSetUpdateStrategyBuilder(){
            this(true);
    }
    public V1beta2DaemonSetUpdateStrategyBuilder(Boolean validationEnabled){
            this(new V1beta2DaemonSetUpdateStrategy(), validationEnabled);
    }
    public V1beta2DaemonSetUpdateStrategyBuilder(V1beta2DaemonSetUpdateStrategyFluent<?> fluent){
            this(fluent, true);
    }
    public V1beta2DaemonSetUpdateStrategyBuilder(V1beta2DaemonSetUpdateStrategyFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1beta2DaemonSetUpdateStrategy(), validationEnabled);
    }
    public V1beta2DaemonSetUpdateStrategyBuilder(V1beta2DaemonSetUpdateStrategyFluent<?> fluent,V1beta2DaemonSetUpdateStrategy instance){
            this(fluent, instance, true);
    }
    public V1beta2DaemonSetUpdateStrategyBuilder(V1beta2DaemonSetUpdateStrategyFluent<?> fluent,V1beta2DaemonSetUpdateStrategy instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withRollingUpdate(instance.getRollingUpdate());

            fluent.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }
    public V1beta2DaemonSetUpdateStrategyBuilder(V1beta2DaemonSetUpdateStrategy instance){
            this(instance,true);
    }
    public V1beta2DaemonSetUpdateStrategyBuilder(V1beta2DaemonSetUpdateStrategy instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withRollingUpdate(instance.getRollingUpdate());

            this.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }

    public V1beta2DaemonSetUpdateStrategy build(){
            V1beta2DaemonSetUpdateStrategy buildable = new V1beta2DaemonSetUpdateStrategy();
            buildable.setRollingUpdate(fluent.getRollingUpdate());
            buildable.setType(fluent.getType());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1beta2DaemonSetUpdateStrategyBuilder that = (V1beta2DaemonSetUpdateStrategyBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
