package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta2StatefulSetBuilder extends V1beta2StatefulSetFluentImpl<V1beta2StatefulSetBuilder> implements VisitableBuilder<V1beta2StatefulSet,V1beta2StatefulSetBuilder>{

    V1beta2StatefulSetFluent<?> fluent;
    Boolean validationEnabled;

    public V1beta2StatefulSetBuilder(){
            this(true);
    }
    public V1beta2StatefulSetBuilder(Boolean validationEnabled){
            this(new V1beta2StatefulSet(), validationEnabled);
    }
    public V1beta2StatefulSetBuilder(V1beta2StatefulSetFluent<?> fluent){
            this(fluent, true);
    }
    public V1beta2StatefulSetBuilder(V1beta2StatefulSetFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1beta2StatefulSet(), validationEnabled);
    }
    public V1beta2StatefulSetBuilder(V1beta2StatefulSetFluent<?> fluent,V1beta2StatefulSet instance){
            this(fluent, instance, true);
    }
    public V1beta2StatefulSetBuilder(V1beta2StatefulSetFluent<?> fluent,V1beta2StatefulSet instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withKind(instance.getKind());

            fluent.withMetadata(instance.getMetadata());

            fluent.withSpec(instance.getSpec());

            fluent.withStatus(instance.getStatus());

            this.validationEnabled = validationEnabled; 
    }
    public V1beta2StatefulSetBuilder(V1beta2StatefulSet instance){
            this(instance,true);
    }
    public V1beta2StatefulSetBuilder(V1beta2StatefulSet instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.withSpec(instance.getSpec());

            this.withStatus(instance.getStatus());

            this.validationEnabled = validationEnabled; 
    }

    public V1beta2StatefulSet build(){
            V1beta2StatefulSet buildable = new V1beta2StatefulSet();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setKind(fluent.getKind());
            buildable.setMetadata(fluent.getMetadata());
            buildable.setSpec(fluent.getSpec());
            buildable.setStatus(fluent.getStatus());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1beta2StatefulSetBuilder that = (V1beta2StatefulSetBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
