package io.kubernetes.client.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.lang.String;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Long;
import java.lang.Object;
import java.lang.Boolean;

public class V2alpha1CronJobSpecFluentImpl<A extends V2alpha1CronJobSpecFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V2alpha1CronJobSpecFluent<A>{

    private String concurrencyPolicy;
    private Integer failedJobsHistoryLimit;
    private V2alpha1JobTemplateSpecBuilder jobTemplate;
    private String schedule;
    private Long startingDeadlineSeconds;
    private Integer successfulJobsHistoryLimit;
    private Boolean suspend;

    public V2alpha1CronJobSpecFluentImpl(){
    }
    public V2alpha1CronJobSpecFluentImpl(V2alpha1CronJobSpec instance){
            this.withConcurrencyPolicy(instance.getConcurrencyPolicy());

            this.withFailedJobsHistoryLimit(instance.getFailedJobsHistoryLimit());

            this.withJobTemplate(instance.getJobTemplate());

            this.withSchedule(instance.getSchedule());

            this.withStartingDeadlineSeconds(instance.getStartingDeadlineSeconds());

            this.withSuccessfulJobsHistoryLimit(instance.getSuccessfulJobsHistoryLimit());

            this.withSuspend(instance.isSuspend());

    }

    public String getConcurrencyPolicy(){
            return this.concurrencyPolicy;
    }

    public A withConcurrencyPolicy(String concurrencyPolicy){
            this.concurrencyPolicy=concurrencyPolicy; return (A) this;
    }

    public Boolean hasConcurrencyPolicy(){
            return this.concurrencyPolicy != null;
    }

    public A withNewConcurrencyPolicy(String arg1){
            return (A)withConcurrencyPolicy(new String(arg1));
    }

    public A withNewConcurrencyPolicy(StringBuilder arg1){
            return (A)withConcurrencyPolicy(new String(arg1));
    }

    public A withNewConcurrencyPolicy(StringBuffer arg1){
            return (A)withConcurrencyPolicy(new String(arg1));
    }

    public Integer getFailedJobsHistoryLimit(){
            return this.failedJobsHistoryLimit;
    }

    public A withFailedJobsHistoryLimit(Integer failedJobsHistoryLimit){
            this.failedJobsHistoryLimit=failedJobsHistoryLimit; return (A) this;
    }

    public Boolean hasFailedJobsHistoryLimit(){
            return this.failedJobsHistoryLimit != null;
    }

    
/**
 * This method has been deprecated, please use method buildJobTemplate instead.
 * @return The buildable object.
 */
@Deprecated public V2alpha1JobTemplateSpec getJobTemplate(){
            return this.jobTemplate!=null?this.jobTemplate.build():null;
    }

    public V2alpha1JobTemplateSpec buildJobTemplate(){
            return this.jobTemplate!=null?this.jobTemplate.build():null;
    }

    public A withJobTemplate(V2alpha1JobTemplateSpec jobTemplate){
            _visitables.get("jobTemplate").remove(this.jobTemplate);
            if (jobTemplate!=null){ this.jobTemplate= new V2alpha1JobTemplateSpecBuilder(jobTemplate); _visitables.get("jobTemplate").add(this.jobTemplate);} return (A) this;
    }

    public Boolean hasJobTemplate(){
            return this.jobTemplate != null;
    }

    public V2alpha1CronJobSpecFluent.JobTemplateNested<A> withNewJobTemplate(){
            return new JobTemplateNestedImpl();
    }

    public V2alpha1CronJobSpecFluent.JobTemplateNested<A> withNewJobTemplateLike(V2alpha1JobTemplateSpec item){
            return new JobTemplateNestedImpl(item);
    }

    public V2alpha1CronJobSpecFluent.JobTemplateNested<A> editJobTemplate(){
            return withNewJobTemplateLike(getJobTemplate());
    }

    public V2alpha1CronJobSpecFluent.JobTemplateNested<A> editOrNewJobTemplate(){
            return withNewJobTemplateLike(getJobTemplate() != null ? getJobTemplate(): new V2alpha1JobTemplateSpecBuilder().build());
    }

    public V2alpha1CronJobSpecFluent.JobTemplateNested<A> editOrNewJobTemplateLike(V2alpha1JobTemplateSpec item){
            return withNewJobTemplateLike(getJobTemplate() != null ? getJobTemplate(): item);
    }

    public String getSchedule(){
            return this.schedule;
    }

    public A withSchedule(String schedule){
            this.schedule=schedule; return (A) this;
    }

    public Boolean hasSchedule(){
            return this.schedule != null;
    }

    public A withNewSchedule(String arg1){
            return (A)withSchedule(new String(arg1));
    }

    public A withNewSchedule(StringBuilder arg1){
            return (A)withSchedule(new String(arg1));
    }

    public A withNewSchedule(StringBuffer arg1){
            return (A)withSchedule(new String(arg1));
    }

    public Long getStartingDeadlineSeconds(){
            return this.startingDeadlineSeconds;
    }

    public A withStartingDeadlineSeconds(Long startingDeadlineSeconds){
            this.startingDeadlineSeconds=startingDeadlineSeconds; return (A) this;
    }

    public Boolean hasStartingDeadlineSeconds(){
            return this.startingDeadlineSeconds != null;
    }

    public Integer getSuccessfulJobsHistoryLimit(){
            return this.successfulJobsHistoryLimit;
    }

    public A withSuccessfulJobsHistoryLimit(Integer successfulJobsHistoryLimit){
            this.successfulJobsHistoryLimit=successfulJobsHistoryLimit; return (A) this;
    }

    public Boolean hasSuccessfulJobsHistoryLimit(){
            return this.successfulJobsHistoryLimit != null;
    }

    public Boolean isSuspend(){
            return this.suspend;
    }

    public A withSuspend(Boolean suspend){
            this.suspend=suspend; return (A) this;
    }

    public Boolean hasSuspend(){
            return this.suspend != null;
    }

    public A withNewSuspend(String arg1){
            return (A)withSuspend(new Boolean(arg1));
    }

    public A withNewSuspend(boolean arg1){
            return (A)withSuspend(new Boolean(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V2alpha1CronJobSpecFluentImpl that = (V2alpha1CronJobSpecFluentImpl) o;
            if (concurrencyPolicy != null ? !concurrencyPolicy.equals(that.concurrencyPolicy) :that.concurrencyPolicy != null) return false;
            if (failedJobsHistoryLimit != null ? !failedJobsHistoryLimit.equals(that.failedJobsHistoryLimit) :that.failedJobsHistoryLimit != null) return false;
            if (jobTemplate != null ? !jobTemplate.equals(that.jobTemplate) :that.jobTemplate != null) return false;
            if (schedule != null ? !schedule.equals(that.schedule) :that.schedule != null) return false;
            if (startingDeadlineSeconds != null ? !startingDeadlineSeconds.equals(that.startingDeadlineSeconds) :that.startingDeadlineSeconds != null) return false;
            if (successfulJobsHistoryLimit != null ? !successfulJobsHistoryLimit.equals(that.successfulJobsHistoryLimit) :that.successfulJobsHistoryLimit != null) return false;
            if (suspend != null ? !suspend.equals(that.suspend) :that.suspend != null) return false;
            return true;
    }


    public class JobTemplateNestedImpl<N> extends V2alpha1JobTemplateSpecFluentImpl<V2alpha1CronJobSpecFluent.JobTemplateNested<N>> implements V2alpha1CronJobSpecFluent.JobTemplateNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V2alpha1JobTemplateSpecBuilder builder;
    
            JobTemplateNestedImpl(V2alpha1JobTemplateSpec item){
                    this.builder = new V2alpha1JobTemplateSpecBuilder(this, item);
            }
            JobTemplateNestedImpl(){
                    this.builder = new V2alpha1JobTemplateSpecBuilder(this);
            }
    
    public N and(){
            return (N) V2alpha1CronJobSpecFluentImpl.this.withJobTemplate(builder.build());
    }
    public N endJobTemplate(){
            return and();
    }

}


}
