package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V2beta1HorizontalPodAutoscalerBuilder extends V2beta1HorizontalPodAutoscalerFluentImpl<V2beta1HorizontalPodAutoscalerBuilder> implements VisitableBuilder<V2beta1HorizontalPodAutoscaler,V2beta1HorizontalPodAutoscalerBuilder>{

    V2beta1HorizontalPodAutoscalerFluent<?> fluent;
    Boolean validationEnabled;

    public V2beta1HorizontalPodAutoscalerBuilder(){
            this(true);
    }
    public V2beta1HorizontalPodAutoscalerBuilder(Boolean validationEnabled){
            this(new V2beta1HorizontalPodAutoscaler(), validationEnabled);
    }
    public V2beta1HorizontalPodAutoscalerBuilder(V2beta1HorizontalPodAutoscalerFluent<?> fluent){
            this(fluent, true);
    }
    public V2beta1HorizontalPodAutoscalerBuilder(V2beta1HorizontalPodAutoscalerFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V2beta1HorizontalPodAutoscaler(), validationEnabled);
    }
    public V2beta1HorizontalPodAutoscalerBuilder(V2beta1HorizontalPodAutoscalerFluent<?> fluent,V2beta1HorizontalPodAutoscaler instance){
            this(fluent, instance, true);
    }
    public V2beta1HorizontalPodAutoscalerBuilder(V2beta1HorizontalPodAutoscalerFluent<?> fluent,V2beta1HorizontalPodAutoscaler instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withKind(instance.getKind());

            fluent.withMetadata(instance.getMetadata());

            fluent.withSpec(instance.getSpec());

            fluent.withStatus(instance.getStatus());

            this.validationEnabled = validationEnabled; 
    }
    public V2beta1HorizontalPodAutoscalerBuilder(V2beta1HorizontalPodAutoscaler instance){
            this(instance,true);
    }
    public V2beta1HorizontalPodAutoscalerBuilder(V2beta1HorizontalPodAutoscaler instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.withSpec(instance.getSpec());

            this.withStatus(instance.getStatus());

            this.validationEnabled = validationEnabled; 
    }

    public V2beta1HorizontalPodAutoscaler build(){
            V2beta1HorizontalPodAutoscaler buildable = new V2beta1HorizontalPodAutoscaler();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setKind(fluent.getKind());
            buildable.setMetadata(fluent.getMetadata());
            buildable.setSpec(fluent.getSpec());
            buildable.setStatus(fluent.getStatus());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V2beta1HorizontalPodAutoscalerBuilder that = (V2beta1HorizontalPodAutoscalerBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
