package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V2beta1PodsMetricSourceBuilder extends V2beta1PodsMetricSourceFluentImpl<V2beta1PodsMetricSourceBuilder> implements VisitableBuilder<V2beta1PodsMetricSource,V2beta1PodsMetricSourceBuilder>{

    V2beta1PodsMetricSourceFluent<?> fluent;
    Boolean validationEnabled;

    public V2beta1PodsMetricSourceBuilder(){
            this(true);
    }
    public V2beta1PodsMetricSourceBuilder(Boolean validationEnabled){
            this(new V2beta1PodsMetricSource(), validationEnabled);
    }
    public V2beta1PodsMetricSourceBuilder(V2beta1PodsMetricSourceFluent<?> fluent){
            this(fluent, true);
    }
    public V2beta1PodsMetricSourceBuilder(V2beta1PodsMetricSourceFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V2beta1PodsMetricSource(), validationEnabled);
    }
    public V2beta1PodsMetricSourceBuilder(V2beta1PodsMetricSourceFluent<?> fluent,V2beta1PodsMetricSource instance){
            this(fluent, instance, true);
    }
    public V2beta1PodsMetricSourceBuilder(V2beta1PodsMetricSourceFluent<?> fluent,V2beta1PodsMetricSource instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withMetricName(instance.getMetricName());

            fluent.withSelector(instance.getSelector());

            fluent.withTargetAverageValue(instance.getTargetAverageValue());

            this.validationEnabled = validationEnabled; 
    }
    public V2beta1PodsMetricSourceBuilder(V2beta1PodsMetricSource instance){
            this(instance,true);
    }
    public V2beta1PodsMetricSourceBuilder(V2beta1PodsMetricSource instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withMetricName(instance.getMetricName());

            this.withSelector(instance.getSelector());

            this.withTargetAverageValue(instance.getTargetAverageValue());

            this.validationEnabled = validationEnabled; 
    }

    public V2beta1PodsMetricSource build(){
            V2beta1PodsMetricSource buildable = new V2beta1PodsMetricSource();
            buildable.setMetricName(fluent.getMetricName());
            buildable.setSelector(fluent.getSelector());
            buildable.setTargetAverageValue(fluent.getTargetAverageValue());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V2beta1PodsMetricSourceBuilder that = (V2beta1PodsMetricSourceBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
