package io.kubernetes.client.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class V2beta1PodsMetricSourceFluentImpl<A extends V2beta1PodsMetricSourceFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V2beta1PodsMetricSourceFluent<A>{

    private String metricName;
    private V1LabelSelectorBuilder selector;
    private String targetAverageValue;

    public V2beta1PodsMetricSourceFluentImpl(){
    }
    public V2beta1PodsMetricSourceFluentImpl(V2beta1PodsMetricSource instance){
            this.withMetricName(instance.getMetricName());

            this.withSelector(instance.getSelector());

            this.withTargetAverageValue(instance.getTargetAverageValue());

    }

    public String getMetricName(){
            return this.metricName;
    }

    public A withMetricName(String metricName){
            this.metricName=metricName; return (A) this;
    }

    public Boolean hasMetricName(){
            return this.metricName != null;
    }

    public A withNewMetricName(String arg1){
            return (A)withMetricName(new String(arg1));
    }

    public A withNewMetricName(StringBuilder arg1){
            return (A)withMetricName(new String(arg1));
    }

    public A withNewMetricName(StringBuffer arg1){
            return (A)withMetricName(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildSelector instead.
 * @return The buildable object.
 */
@Deprecated public V1LabelSelector getSelector(){
            return this.selector!=null?this.selector.build():null;
    }

    public V1LabelSelector buildSelector(){
            return this.selector!=null?this.selector.build():null;
    }

    public A withSelector(V1LabelSelector selector){
            _visitables.get("selector").remove(this.selector);
            if (selector!=null){ this.selector= new V1LabelSelectorBuilder(selector); _visitables.get("selector").add(this.selector);} return (A) this;
    }

    public Boolean hasSelector(){
            return this.selector != null;
    }

    public V2beta1PodsMetricSourceFluent.SelectorNested<A> withNewSelector(){
            return new SelectorNestedImpl();
    }

    public V2beta1PodsMetricSourceFluent.SelectorNested<A> withNewSelectorLike(V1LabelSelector item){
            return new SelectorNestedImpl(item);
    }

    public V2beta1PodsMetricSourceFluent.SelectorNested<A> editSelector(){
            return withNewSelectorLike(getSelector());
    }

    public V2beta1PodsMetricSourceFluent.SelectorNested<A> editOrNewSelector(){
            return withNewSelectorLike(getSelector() != null ? getSelector(): new V1LabelSelectorBuilder().build());
    }

    public V2beta1PodsMetricSourceFluent.SelectorNested<A> editOrNewSelectorLike(V1LabelSelector item){
            return withNewSelectorLike(getSelector() != null ? getSelector(): item);
    }

    public String getTargetAverageValue(){
            return this.targetAverageValue;
    }

    public A withTargetAverageValue(String targetAverageValue){
            this.targetAverageValue=targetAverageValue; return (A) this;
    }

    public Boolean hasTargetAverageValue(){
            return this.targetAverageValue != null;
    }

    public A withNewTargetAverageValue(String arg1){
            return (A)withTargetAverageValue(new String(arg1));
    }

    public A withNewTargetAverageValue(StringBuilder arg1){
            return (A)withTargetAverageValue(new String(arg1));
    }

    public A withNewTargetAverageValue(StringBuffer arg1){
            return (A)withTargetAverageValue(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V2beta1PodsMetricSourceFluentImpl that = (V2beta1PodsMetricSourceFluentImpl) o;
            if (metricName != null ? !metricName.equals(that.metricName) :that.metricName != null) return false;
            if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
            if (targetAverageValue != null ? !targetAverageValue.equals(that.targetAverageValue) :that.targetAverageValue != null) return false;
            return true;
    }


    public class SelectorNestedImpl<N> extends V1LabelSelectorFluentImpl<V2beta1PodsMetricSourceFluent.SelectorNested<N>> implements V2beta1PodsMetricSourceFluent.SelectorNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1LabelSelectorBuilder builder;
    
            SelectorNestedImpl(V1LabelSelector item){
                    this.builder = new V1LabelSelectorBuilder(this, item);
            }
            SelectorNestedImpl(){
                    this.builder = new V1LabelSelectorBuilder(this);
            }
    
    public N and(){
            return (N) V2beta1PodsMetricSourceFluentImpl.this.withSelector(builder.build());
    }
    public N endSelector(){
            return and();
    }

}


}
