package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import org.joda.time.DateTime;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;

public class V2beta2HorizontalPodAutoscalerStatusFluentImpl<A extends V2beta2HorizontalPodAutoscalerStatusFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V2beta2HorizontalPodAutoscalerStatusFluent<A>{

    private List<V2beta2HorizontalPodAutoscalerConditionBuilder> conditions;
    private List<V2beta2MetricStatusBuilder> currentMetrics;
    private Integer currentReplicas;
    private Integer desiredReplicas;
    private DateTime lastScaleTime;
    private Long observedGeneration;

    public V2beta2HorizontalPodAutoscalerStatusFluentImpl(){
    }
    public V2beta2HorizontalPodAutoscalerStatusFluentImpl(V2beta2HorizontalPodAutoscalerStatus instance){
            this.withConditions(instance.getConditions());

            this.withCurrentMetrics(instance.getCurrentMetrics());

            this.withCurrentReplicas(instance.getCurrentReplicas());

            this.withDesiredReplicas(instance.getDesiredReplicas());

            this.withLastScaleTime(instance.getLastScaleTime());

            this.withObservedGeneration(instance.getObservedGeneration());

    }

    public A addToConditions(int index,V2beta2HorizontalPodAutoscalerCondition item){
            if (this.conditions == null) {this.conditions = new ArrayList<V2beta2HorizontalPodAutoscalerConditionBuilder>();}
            V2beta2HorizontalPodAutoscalerConditionBuilder builder = new V2beta2HorizontalPodAutoscalerConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
    }

    public A setToConditions(int index,V2beta2HorizontalPodAutoscalerCondition item){
            if (this.conditions == null) {this.conditions = new ArrayList<V2beta2HorizontalPodAutoscalerConditionBuilder>();}
            V2beta2HorizontalPodAutoscalerConditionBuilder builder = new V2beta2HorizontalPodAutoscalerConditionBuilder(item);
            if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
            if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
             return (A)this;
    }

    public A addToConditions(V2beta2HorizontalPodAutoscalerCondition... items){
            if (this.conditions == null) {this.conditions = new ArrayList<V2beta2HorizontalPodAutoscalerConditionBuilder>();}
            for (V2beta2HorizontalPodAutoscalerCondition item : items) {V2beta2HorizontalPodAutoscalerConditionBuilder builder = new V2beta2HorizontalPodAutoscalerConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A addAllToConditions(Collection<V2beta2HorizontalPodAutoscalerCondition> items){
            if (this.conditions == null) {this.conditions = new ArrayList<V2beta2HorizontalPodAutoscalerConditionBuilder>();}
            for (V2beta2HorizontalPodAutoscalerCondition item : items) {V2beta2HorizontalPodAutoscalerConditionBuilder builder = new V2beta2HorizontalPodAutoscalerConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A removeFromConditions(V2beta2HorizontalPodAutoscalerCondition... items){
            for (V2beta2HorizontalPodAutoscalerCondition item : items) {V2beta2HorizontalPodAutoscalerConditionBuilder builder = new V2beta2HorizontalPodAutoscalerConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeAllFromConditions(Collection<V2beta2HorizontalPodAutoscalerCondition> items){
            for (V2beta2HorizontalPodAutoscalerCondition item : items) {V2beta2HorizontalPodAutoscalerConditionBuilder builder = new V2beta2HorizontalPodAutoscalerConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<V2beta2HorizontalPodAutoscalerCondition> getConditions(){
            return build(conditions);
    }

    public List<V2beta2HorizontalPodAutoscalerCondition> buildConditions(){
            return build(conditions);
    }

    public V2beta2HorizontalPodAutoscalerCondition buildCondition(int index){
            return this.conditions.get(index).build();
    }

    public V2beta2HorizontalPodAutoscalerCondition buildFirstCondition(){
            return this.conditions.get(0).build();
    }

    public V2beta2HorizontalPodAutoscalerCondition buildLastCondition(){
            return this.conditions.get(conditions.size() - 1).build();
    }

    public V2beta2HorizontalPodAutoscalerCondition buildMatchingCondition(io.kubernetes.client.fluent.Predicate<V2beta2HorizontalPodAutoscalerConditionBuilder> predicate){
            for (V2beta2HorizontalPodAutoscalerConditionBuilder item: conditions) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingCondition(io.kubernetes.client.fluent.Predicate<V2beta2HorizontalPodAutoscalerConditionBuilder> predicate){
            for (V2beta2HorizontalPodAutoscalerConditionBuilder item: conditions) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withConditions(List<V2beta2HorizontalPodAutoscalerCondition> conditions){
            if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
            if (conditions != null) {this.conditions = new ArrayList<V2beta2HorizontalPodAutoscalerConditionBuilder>(); for (V2beta2HorizontalPodAutoscalerCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
    }

    public A withConditions(V2beta2HorizontalPodAutoscalerCondition... conditions){
            if (this.conditions != null) {this.conditions.clear();}
            if (conditions != null) {for (V2beta2HorizontalPodAutoscalerCondition item :conditions){ this.addToConditions(item);}} return (A) this;
    }

    public Boolean hasConditions(){
            return conditions != null && !conditions.isEmpty();
    }

    public V2beta2HorizontalPodAutoscalerStatusFluent.ConditionsNested<A> addNewCondition(){
            return new ConditionsNestedImpl();
    }

    public V2beta2HorizontalPodAutoscalerStatusFluent.ConditionsNested<A> addNewConditionLike(V2beta2HorizontalPodAutoscalerCondition item){
            return new ConditionsNestedImpl(-1, item);
    }

    public V2beta2HorizontalPodAutoscalerStatusFluent.ConditionsNested<A> setNewConditionLike(int index,V2beta2HorizontalPodAutoscalerCondition item){
            return new ConditionsNestedImpl(index, item);
    }

    public V2beta2HorizontalPodAutoscalerStatusFluent.ConditionsNested<A> editCondition(int index){
            if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
            return setNewConditionLike(index, buildCondition(index));
    }

    public V2beta2HorizontalPodAutoscalerStatusFluent.ConditionsNested<A> editFirstCondition(){
            if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
            return setNewConditionLike(0, buildCondition(0));
    }

    public V2beta2HorizontalPodAutoscalerStatusFluent.ConditionsNested<A> editLastCondition(){
            int index = conditions.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
            return setNewConditionLike(index, buildCondition(index));
    }

    public V2beta2HorizontalPodAutoscalerStatusFluent.ConditionsNested<A> editMatchingCondition(io.kubernetes.client.fluent.Predicate<V2beta2HorizontalPodAutoscalerConditionBuilder> predicate){
            int index = -1;
            for (int i=0;i<conditions.size();i++) { 
            if (predicate.apply(conditions.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
            return setNewConditionLike(index, buildCondition(index));
    }

    public A addToCurrentMetrics(int index,V2beta2MetricStatus item){
            if (this.currentMetrics == null) {this.currentMetrics = new ArrayList<V2beta2MetricStatusBuilder>();}
            V2beta2MetricStatusBuilder builder = new V2beta2MetricStatusBuilder(item);_visitables.get("currentMetrics").add(index >= 0 ? index : _visitables.get("currentMetrics").size(), builder);this.currentMetrics.add(index >= 0 ? index : currentMetrics.size(), builder); return (A)this;
    }

    public A setToCurrentMetrics(int index,V2beta2MetricStatus item){
            if (this.currentMetrics == null) {this.currentMetrics = new ArrayList<V2beta2MetricStatusBuilder>();}
            V2beta2MetricStatusBuilder builder = new V2beta2MetricStatusBuilder(item);
            if (index < 0 || index >= _visitables.get("currentMetrics").size()) { _visitables.get("currentMetrics").add(builder); } else { _visitables.get("currentMetrics").set(index, builder);}
            if (index < 0 || index >= currentMetrics.size()) { currentMetrics.add(builder); } else { currentMetrics.set(index, builder);}
             return (A)this;
    }

    public A addToCurrentMetrics(V2beta2MetricStatus... items){
            if (this.currentMetrics == null) {this.currentMetrics = new ArrayList<V2beta2MetricStatusBuilder>();}
            for (V2beta2MetricStatus item : items) {V2beta2MetricStatusBuilder builder = new V2beta2MetricStatusBuilder(item);_visitables.get("currentMetrics").add(builder);this.currentMetrics.add(builder);} return (A)this;
    }

    public A addAllToCurrentMetrics(Collection<V2beta2MetricStatus> items){
            if (this.currentMetrics == null) {this.currentMetrics = new ArrayList<V2beta2MetricStatusBuilder>();}
            for (V2beta2MetricStatus item : items) {V2beta2MetricStatusBuilder builder = new V2beta2MetricStatusBuilder(item);_visitables.get("currentMetrics").add(builder);this.currentMetrics.add(builder);} return (A)this;
    }

    public A removeFromCurrentMetrics(V2beta2MetricStatus... items){
            for (V2beta2MetricStatus item : items) {V2beta2MetricStatusBuilder builder = new V2beta2MetricStatusBuilder(item);_visitables.get("currentMetrics").remove(builder);if (this.currentMetrics != null) {this.currentMetrics.remove(builder);}} return (A)this;
    }

    public A removeAllFromCurrentMetrics(Collection<V2beta2MetricStatus> items){
            for (V2beta2MetricStatus item : items) {V2beta2MetricStatusBuilder builder = new V2beta2MetricStatusBuilder(item);_visitables.get("currentMetrics").remove(builder);if (this.currentMetrics != null) {this.currentMetrics.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildCurrentMetrics instead.
 * @return The buildable object.
 */
@Deprecated public List<V2beta2MetricStatus> getCurrentMetrics(){
            return build(currentMetrics);
    }

    public List<V2beta2MetricStatus> buildCurrentMetrics(){
            return build(currentMetrics);
    }

    public V2beta2MetricStatus buildCurrentMetric(int index){
            return this.currentMetrics.get(index).build();
    }

    public V2beta2MetricStatus buildFirstCurrentMetric(){
            return this.currentMetrics.get(0).build();
    }

    public V2beta2MetricStatus buildLastCurrentMetric(){
            return this.currentMetrics.get(currentMetrics.size() - 1).build();
    }

    public V2beta2MetricStatus buildMatchingCurrentMetric(io.kubernetes.client.fluent.Predicate<V2beta2MetricStatusBuilder> predicate){
            for (V2beta2MetricStatusBuilder item: currentMetrics) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingCurrentMetric(io.kubernetes.client.fluent.Predicate<V2beta2MetricStatusBuilder> predicate){
            for (V2beta2MetricStatusBuilder item: currentMetrics) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withCurrentMetrics(List<V2beta2MetricStatus> currentMetrics){
            if (this.currentMetrics != null) { _visitables.get("currentMetrics").removeAll(this.currentMetrics);}
            if (currentMetrics != null) {this.currentMetrics = new ArrayList<V2beta2MetricStatusBuilder>(); for (V2beta2MetricStatus item : currentMetrics){this.addToCurrentMetrics(item);}} else { this.currentMetrics = null;} return (A) this;
    }

    public A withCurrentMetrics(V2beta2MetricStatus... currentMetrics){
            if (this.currentMetrics != null) {this.currentMetrics.clear();}
            if (currentMetrics != null) {for (V2beta2MetricStatus item :currentMetrics){ this.addToCurrentMetrics(item);}} return (A) this;
    }

    public Boolean hasCurrentMetrics(){
            return currentMetrics != null && !currentMetrics.isEmpty();
    }

    public V2beta2HorizontalPodAutoscalerStatusFluent.CurrentMetricsNested<A> addNewCurrentMetric(){
            return new CurrentMetricsNestedImpl();
    }

    public V2beta2HorizontalPodAutoscalerStatusFluent.CurrentMetricsNested<A> addNewCurrentMetricLike(V2beta2MetricStatus item){
            return new CurrentMetricsNestedImpl(-1, item);
    }

    public V2beta2HorizontalPodAutoscalerStatusFluent.CurrentMetricsNested<A> setNewCurrentMetricLike(int index,V2beta2MetricStatus item){
            return new CurrentMetricsNestedImpl(index, item);
    }

    public V2beta2HorizontalPodAutoscalerStatusFluent.CurrentMetricsNested<A> editCurrentMetric(int index){
            if (currentMetrics.size() <= index) throw new RuntimeException("Can't edit currentMetrics. Index exceeds size.");
            return setNewCurrentMetricLike(index, buildCurrentMetric(index));
    }

    public V2beta2HorizontalPodAutoscalerStatusFluent.CurrentMetricsNested<A> editFirstCurrentMetric(){
            if (currentMetrics.size() == 0) throw new RuntimeException("Can't edit first currentMetrics. The list is empty.");
            return setNewCurrentMetricLike(0, buildCurrentMetric(0));
    }

    public V2beta2HorizontalPodAutoscalerStatusFluent.CurrentMetricsNested<A> editLastCurrentMetric(){
            int index = currentMetrics.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last currentMetrics. The list is empty.");
            return setNewCurrentMetricLike(index, buildCurrentMetric(index));
    }

    public V2beta2HorizontalPodAutoscalerStatusFluent.CurrentMetricsNested<A> editMatchingCurrentMetric(io.kubernetes.client.fluent.Predicate<V2beta2MetricStatusBuilder> predicate){
            int index = -1;
            for (int i=0;i<currentMetrics.size();i++) { 
            if (predicate.apply(currentMetrics.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching currentMetrics. No match found.");
            return setNewCurrentMetricLike(index, buildCurrentMetric(index));
    }

    public Integer getCurrentReplicas(){
            return this.currentReplicas;
    }

    public A withCurrentReplicas(Integer currentReplicas){
            this.currentReplicas=currentReplicas; return (A) this;
    }

    public Boolean hasCurrentReplicas(){
            return this.currentReplicas != null;
    }

    public Integer getDesiredReplicas(){
            return this.desiredReplicas;
    }

    public A withDesiredReplicas(Integer desiredReplicas){
            this.desiredReplicas=desiredReplicas; return (A) this;
    }

    public Boolean hasDesiredReplicas(){
            return this.desiredReplicas != null;
    }

    public DateTime getLastScaleTime(){
            return this.lastScaleTime;
    }

    public A withLastScaleTime(DateTime lastScaleTime){
            this.lastScaleTime=lastScaleTime; return (A) this;
    }

    public Boolean hasLastScaleTime(){
            return this.lastScaleTime != null;
    }

    public A withNewLastScaleTime(int arg0,int arg1,int arg2,int arg3,int arg4){
            return (A)withLastScaleTime(new DateTime(arg0, arg1, arg2, arg3, arg4));
    }

    public A withNewLastScaleTime(Object arg0){
            return (A)withLastScaleTime(new DateTime(arg0));
    }

    public A withNewLastScaleTime(long arg0){
            return (A)withLastScaleTime(new DateTime(arg0));
    }

    public Long getObservedGeneration(){
            return this.observedGeneration;
    }

    public A withObservedGeneration(Long observedGeneration){
            this.observedGeneration=observedGeneration; return (A) this;
    }

    public Boolean hasObservedGeneration(){
            return this.observedGeneration != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V2beta2HorizontalPodAutoscalerStatusFluentImpl that = (V2beta2HorizontalPodAutoscalerStatusFluentImpl) o;
            if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
            if (currentMetrics != null ? !currentMetrics.equals(that.currentMetrics) :that.currentMetrics != null) return false;
            if (currentReplicas != null ? !currentReplicas.equals(that.currentReplicas) :that.currentReplicas != null) return false;
            if (desiredReplicas != null ? !desiredReplicas.equals(that.desiredReplicas) :that.desiredReplicas != null) return false;
            if (lastScaleTime != null ? !lastScaleTime.equals(that.lastScaleTime) :that.lastScaleTime != null) return false;
            if (observedGeneration != null ? !observedGeneration.equals(that.observedGeneration) :that.observedGeneration != null) return false;
            return true;
    }


    public class ConditionsNestedImpl<N> extends V2beta2HorizontalPodAutoscalerConditionFluentImpl<V2beta2HorizontalPodAutoscalerStatusFluent.ConditionsNested<N>> implements V2beta2HorizontalPodAutoscalerStatusFluent.ConditionsNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V2beta2HorizontalPodAutoscalerConditionBuilder builder;
        private final int index;
    
            ConditionsNestedImpl(int index,V2beta2HorizontalPodAutoscalerCondition item){
                    this.index = index;
                    this.builder = new V2beta2HorizontalPodAutoscalerConditionBuilder(this, item);
            }
            ConditionsNestedImpl(){
                    this.index = -1;
                    this.builder = new V2beta2HorizontalPodAutoscalerConditionBuilder(this);
            }
    
    public N and(){
            return (N) V2beta2HorizontalPodAutoscalerStatusFluentImpl.this.setToConditions(index, builder.build());
    }
    public N endCondition(){
            return and();
    }

}
    public class CurrentMetricsNestedImpl<N> extends V2beta2MetricStatusFluentImpl<V2beta2HorizontalPodAutoscalerStatusFluent.CurrentMetricsNested<N>> implements V2beta2HorizontalPodAutoscalerStatusFluent.CurrentMetricsNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V2beta2MetricStatusBuilder builder;
        private final int index;
    
            CurrentMetricsNestedImpl(int index,V2beta2MetricStatus item){
                    this.index = index;
                    this.builder = new V2beta2MetricStatusBuilder(this, item);
            }
            CurrentMetricsNestedImpl(){
                    this.index = -1;
                    this.builder = new V2beta2MetricStatusBuilder(this);
            }
    
    public N and(){
            return (N) V2beta2HorizontalPodAutoscalerStatusFluentImpl.this.setToCurrentMetrics(index, builder.build());
    }
    public N endCurrentMetric(){
            return and();
    }

}


}
