/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.V1PodTemplateSpec;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="ReplicationControllerSpec is the specification of a replication controller.")
public class V1ReplicationControllerSpec {
    @SerializedName(value="minReadySeconds")
    private Integer minReadySeconds = null;
    @SerializedName(value="replicas")
    private Integer replicas = null;
    @SerializedName(value="selector")
    private Map<String, String> selector = null;
    @SerializedName(value="template")
    private V1PodTemplateSpec template = null;

    public V1ReplicationControllerSpec minReadySeconds(Integer minReadySeconds) {
        this.minReadySeconds = minReadySeconds;
        return this;
    }

    @ApiModelProperty(value="Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)")
    public Integer getMinReadySeconds() {
        return this.minReadySeconds;
    }

    public void setMinReadySeconds(Integer minReadySeconds) {
        this.minReadySeconds = minReadySeconds;
    }

    public V1ReplicationControllerSpec replicas(Integer replicas) {
        this.replicas = replicas;
        return this;
    }

    @ApiModelProperty(value="Replicas is the number of desired replicas. This is a pointer to distinguish between explicit zero and unspecified. Defaults to 1. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#what-is-a-replicationcontroller")
    public Integer getReplicas() {
        return this.replicas;
    }

    public void setReplicas(Integer replicas) {
        this.replicas = replicas;
    }

    public V1ReplicationControllerSpec selector(Map<String, String> selector) {
        this.selector = selector;
        return this;
    }

    public V1ReplicationControllerSpec putSelectorItem(String key, String selectorItem) {
        if (this.selector == null) {
            this.selector = new HashMap<String, String>();
        }
        this.selector.put(key, selectorItem);
        return this;
    }

    @ApiModelProperty(value="Selector is a label query over pods that should match the Replicas count. If Selector is empty, it is defaulted to the labels present on the Pod template. Label keys and values that must match in order to be controlled by this replication controller, if empty defaulted to labels on Pod template. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors")
    public Map<String, String> getSelector() {
        return this.selector;
    }

    public void setSelector(Map<String, String> selector) {
        this.selector = selector;
    }

    public V1ReplicationControllerSpec template(V1PodTemplateSpec template) {
        this.template = template;
        return this;
    }

    @ApiModelProperty(value="Template is the object that describes the pod that will be created if insufficient replicas are detected. This takes precedence over a TemplateRef. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template")
    public V1PodTemplateSpec getTemplate() {
        return this.template;
    }

    public void setTemplate(V1PodTemplateSpec template) {
        this.template = template;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ReplicationControllerSpec v1ReplicationControllerSpec = (V1ReplicationControllerSpec)o;
        return Objects.equals(this.minReadySeconds, v1ReplicationControllerSpec.minReadySeconds) && Objects.equals(this.replicas, v1ReplicationControllerSpec.replicas) && Objects.equals(this.selector, v1ReplicationControllerSpec.selector) && Objects.equals(this.template, v1ReplicationControllerSpec.template);
    }

    public int hashCode() {
        return Objects.hash(this.minReadySeconds, this.replicas, this.selector, this.template);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ReplicationControllerSpec {\n");
        sb.append("    minReadySeconds: ").append(this.toIndentedString(this.minReadySeconds)).append("\n");
        sb.append("    replicas: ").append(this.toIndentedString(this.replicas)).append("\n");
        sb.append("    selector: ").append(this.toIndentedString(this.selector)).append("\n");
        sb.append("    template: ").append(this.toIndentedString(this.template)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

