/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.spqr.spring.web;

import io.leangen.graphql.spqr.spring.autoconfigure.SpqrProperties;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Controller;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class GuiController {
    private final SpqrProperties config;

    public GuiController(SpqrProperties config) {
        this.config = config;
    }

    @ResponseBody
    @RequestMapping(value={"${graphql.spqr.gui.endpoint:/gui}"}, produces={"text/html; charset=utf-8"})
    public String gui() throws IOException {
        return StreamUtils.copyToString((InputStream)new ClassPathResource("playground.html").getInputStream(), (Charset)StandardCharsets.UTF_8).replace("${pageTitle}", this.config.getGui().getPageTitle()).replace("${graphQLEndpoint}", this.config.getGui().getTargetEndpoint()).replace("${webSocketEndpoint}", this.config.getGui().getTargetWsEndpoint());
    }
}

