/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.spqr.spring.web.apollo;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import graphql.ErrorType;
import graphql.ExecutionResult;
import graphql.GraphQLError;
import io.leangen.graphql.spqr.spring.web.apollo.ConnectionErrorMessage;
import io.leangen.graphql.spqr.spring.web.apollo.DataMessage;
import io.leangen.graphql.spqr.spring.web.apollo.ErrorMessage;
import io.leangen.graphql.spqr.spring.web.apollo.InitMessage;
import io.leangen.graphql.spqr.spring.web.apollo.StartMessage;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.web.socket.TextMessage;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", visible=true, include=JsonTypeInfo.As.EXISTING_PROPERTY)
@JsonSubTypes(value={@JsonSubTypes.Type(value=InitMessage.class, name="connection_init"), @JsonSubTypes.Type(value=ApolloMessage.class, name="connection_terminate"), @JsonSubTypes.Type(value=ApolloMessage.class, name="stop"), @JsonSubTypes.Type(value=StartMessage.class, name="start")})
public class ApolloMessage {
    private final String id;
    private final String type;
    public static final String GQL_CONNECTION_INIT = "connection_init";
    public static final String GQL_CONNECTION_TERMINATE = "connection_terminate";
    public static final String GQL_START = "start";
    public static final String GQL_STOP = "stop";
    public static final String GQL_CONNECTION_ACK = "connection_ack";
    public static final String GQL_CONNECTION_ERROR = "connection_error";
    public static final String GQL_CONNECTION_KEEP_ALIVE = "ka";
    public static final String GQL_DATA = "data";
    public static final String GQL_ERROR = "error";
    public static final String GQL_COMPLETE = "complete";
    private static final ApolloMessage CONNECTION_ACK = new ApolloMessage("connection_ack");
    private static final ApolloMessage KEEP_ALIVE = new ApolloMessage("ka");
    private static final ObjectMapper mapper = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL);

    private ApolloMessage(String type) {
        this(null, type);
    }

    @JsonCreator
    public ApolloMessage(@JsonProperty(value="id") String id, @JsonProperty(value="type") String type) {
        this.id = id;
        this.type = type;
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public static ApolloMessage from(TextMessage message) throws IOException {
        return (ApolloMessage)mapper.readValue((String)message.getPayload(), ApolloMessage.class);
    }

    public static TextMessage connectionAck() throws JsonProcessingException {
        return ApolloMessage.jsonMessage(CONNECTION_ACK);
    }

    public static TextMessage keepAlive() throws JsonProcessingException {
        return ApolloMessage.jsonMessage(KEEP_ALIVE);
    }

    public static TextMessage connectionError() throws JsonProcessingException {
        return ApolloMessage.jsonMessage(new ConnectionErrorMessage(Collections.singletonMap("message", "Invalid message")));
    }

    public static TextMessage data(String id, ExecutionResult result) throws JsonProcessingException {
        return ApolloMessage.jsonMessage(new DataMessage(id, result));
    }

    public static TextMessage complete(String id) throws JsonProcessingException {
        return ApolloMessage.jsonMessage(new ApolloMessage(id, GQL_COMPLETE));
    }

    public static TextMessage error(String id, List<GraphQLError> errors) throws JsonProcessingException {
        return ApolloMessage.jsonMessage(new ErrorMessage(id, errors.stream().filter(error -> !error.getErrorType().equals((Object)ErrorType.DataFetchingException)).map(GraphQLError::toSpecification).collect(Collectors.toList())));
    }

    public static TextMessage error(String id, Throwable exception) throws JsonProcessingException {
        return ApolloMessage.jsonMessage(new ErrorMessage(id, Collections.singletonList(Collections.singletonMap("message", exception.getMessage()))));
    }

    private static TextMessage jsonMessage(ApolloMessage message) throws JsonProcessingException {
        return new TextMessage((CharSequence)mapper.writeValueAsString((Object)message));
    }
}

