/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.spqr.spring.web.apollo;

import graphql.ExecutionResult;
import graphql.GraphQL;
import io.leangen.graphql.spqr.spring.web.apollo.ApolloMessage;
import io.leangen.graphql.spqr.spring.web.apollo.StartMessage;
import io.leangen.graphql.spqr.spring.web.dto.GraphQLRequest;
import io.leangen.graphql.spqr.spring.web.servlet.websocket.GraphQLWebSocketExecutor;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.TextWebSocketHandler;

class ApolloProtocolHandler
extends TextWebSocketHandler {
    private final GraphQL graphQL;
    private final GraphQLWebSocketExecutor executor;
    private final TaskScheduler taskScheduler;
    private final int keepAliveInterval;
    private final Map<String, Subscription> subscriptions = new ConcurrentHashMap<String, Subscription>();
    private final AtomicReference<ScheduledFuture<?>> keepAlive = new AtomicReference();
    private static final Logger log = LoggerFactory.getLogger(ApolloProtocolHandler.class);

    public ApolloProtocolHandler(GraphQL graphQL, GraphQLWebSocketExecutor executor, TaskScheduler taskScheduler, int keepAliveInterval) {
        this.graphQL = graphQL;
        this.executor = executor;
        this.taskScheduler = taskScheduler;
        this.keepAliveInterval = keepAliveInterval;
    }

    public void afterConnectionEstablished(WebSocketSession session) throws Exception {
        super.afterConnectionEstablished(session);
        if (this.taskScheduler != null) {
            this.keepAlive.compareAndSet(null, this.taskScheduler.scheduleWithFixedDelay(this.keepAliveTask(session), (long)Math.max(this.keepAliveInterval, 1000)));
        }
    }

    public void afterConnectionClosed(WebSocketSession session, CloseStatus status) {
        this.cancelAll();
        if (this.taskScheduler != null) {
            this.keepAlive.getAndUpdate(task -> {
                if (task != null) {
                    task.cancel(false);
                }
                return null;
            });
        }
    }

    public void handleTransportError(WebSocketSession session, Throwable exception) throws Exception {
        session.close(CloseStatus.SERVER_ERROR);
        this.cancelAll();
    }

    protected void handleTextMessage(WebSocketSession session, TextMessage message) {
        try {
            ApolloMessage apolloMessage;
            try {
                apolloMessage = ApolloMessage.from(message);
            }
            catch (IOException e) {
                session.sendMessage((WebSocketMessage)ApolloMessage.connectionError());
                return;
            }
            switch (apolloMessage.getType()) {
                case "connection_init": {
                    session.sendMessage((WebSocketMessage)ApolloMessage.connectionAck());
                    if (this.taskScheduler == null) break;
                    session.sendMessage((WebSocketMessage)ApolloMessage.keepAlive());
                    break;
                }
                case "start": {
                    GraphQLRequest request = (GraphQLRequest)((StartMessage)apolloMessage).getPayload();
                    ExecutionResult result = this.executor.execute(this.graphQL, request, session);
                    if (result.getData() instanceof Publisher) {
                        this.handleSubscription(apolloMessage.getId(), result, session);
                        break;
                    }
                    this.handleQueryOrMutation(apolloMessage.getId(), result, session);
                    break;
                }
                case "stop": {
                    Subscription toStop = this.subscriptions.get(apolloMessage.getId());
                    if (toStop == null) break;
                    toStop.cancel();
                    this.subscriptions.remove(apolloMessage.getId(), toStop);
                    break;
                }
                case "connection_terminate": {
                    session.close();
                    this.cancelAll();
                }
            }
        }
        catch (IOException e) {
            this.fatalError(session, e);
        }
    }

    private void handleQueryOrMutation(String id, ExecutionResult result, WebSocketSession session) {
        try {
            session.sendMessage((WebSocketMessage)ApolloMessage.data(id, result));
            session.sendMessage((WebSocketMessage)ApolloMessage.complete(id));
        }
        catch (IOException e) {
            this.fatalError(session, e);
        }
    }

    private void handleSubscription(final String id, ExecutionResult result, final WebSocketSession session) {
        Publisher stream = (Publisher)result.getData();
        Subscriber<ExecutionResult> subscriber = new Subscriber<ExecutionResult>(){
            private Subscription subscription;

            public void onSubscribe(Subscription subscription) {
                this.subscription = subscription;
                ApolloProtocolHandler.this.subscriptions.put(id, subscription);
                this.request(1);
            }

            public void onNext(ExecutionResult executionResult) {
                try {
                    if (executionResult.getErrors().isEmpty()) {
                        session.sendMessage((WebSocketMessage)ApolloMessage.data(id, executionResult));
                    } else {
                        session.sendMessage((WebSocketMessage)ApolloMessage.error(id, executionResult.getErrors()));
                    }
                }
                catch (IOException e) {
                    ApolloProtocolHandler.this.fatalError(session, e);
                }
                this.request(1);
            }

            public void onError(Throwable t) {
                try {
                    session.sendMessage((WebSocketMessage)ApolloMessage.error(id, t));
                }
                catch (IOException e) {
                    ApolloProtocolHandler.this.fatalError(session, e);
                }
            }

            public void onComplete() {
                try {
                    session.sendMessage((WebSocketMessage)ApolloMessage.complete(id));
                }
                catch (IOException e) {
                    ApolloProtocolHandler.this.fatalError(session, e);
                }
            }

            private void request(int n) {
                Subscription subscription = this.subscription;
                if (subscription != null) {
                    subscription.request((long)n);
                }
            }
        };
        stream.subscribe((Subscriber)subscriber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelAll() {
        Map<String, Subscription> map = this.subscriptions;
        synchronized (map) {
            this.subscriptions.values().forEach(Subscription::cancel);
            this.subscriptions.clear();
        }
    }

    private void fatalError(WebSocketSession session, Exception exception) {
        try {
            session.close(CloseStatus.SESSION_NOT_RELIABLE);
        }
        catch (Exception exception2) {
            // empty catch block
        }
        this.cancelAll();
        log.warn(String.format("WebSocket session %s (%s) closed due to an exception", session.getId(), session.getRemoteAddress()), (Throwable)exception);
    }

    private Runnable keepAliveTask(WebSocketSession session) {
        return () -> {
            try {
                if (session != null && session.isOpen()) {
                    session.sendMessage((WebSocketMessage)ApolloMessage.keepAlive());
                }
            }
            catch (Exception exception) {
                try {
                    session.close(CloseStatus.SESSION_NOT_RELIABLE);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        };
    }
}

